/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.cdm;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.imviewer.util.cdm.PlaneSlicingDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.cdm.PlaneSlicingPane;

class PlaneSlicingPaneStatic
extends JPanel {
    private static final int topBorder = 20;
    private static final int leftBorder = 40;
    private static final int square = 140;
    private static final int bottomBorder = 30;
    private static final int lS = 180;
    private static final int tS = 160;
    private static final int tS4 = 50;
    private static final int rStart = 100;
    private static final int rEnd = 120;
    private static final int yStart = 100;
    private static final int yEnd = 80;
    private PlaneSlicingDialog model;

    PlaneSlicingPaneStatic(PlaneSlicingDialog model) {
        this.model = model;
    }

    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(PlaneSlicingPane.bgColor);
        g2D.fillRect(0, 0, 220, 200);
        Font font = g2D.getFont();
        FontMetrics fontMetrics = g2D.getFontMetrics();
        int hFont = fontMetrics.getHeight();
        Rectangle2D rInput = font.getStringBounds("(2) Input", g2D.getFontRenderContext());
        int wInput = (int)rInput.getWidth();
        AffineTransform transform = new AffineTransform();
        transform.translate(110.0, 90.0);
        transform.scale(1.0, -1.0);
        transform.scale(10.0, 10.0);
        g2D.setPaint(PlaneSlicingPane.gridColor);
        GeneralPath path = new GeneralPath();
        for (i = -7; i <= 7; ++i) {
            path.moveTo(i, -7.0f);
            path.lineTo(i, 7.0f);
        }
        for (i = -7; i <= 7; ++i) {
            path.moveTo(-7.0f, i);
            path.lineTo(7.0f, i);
        }
        g2D.draw(transform.createTransformedShape(path));
        g2D.setColor(PlaneSlicingPane.axisColor);
        g2D.drawLine(40, 12, 40, 165);
        g2D.drawLine(40, 12, 37, 15);
        g2D.drawLine(40, 12, 43, 15);
        g2D.drawLine(35, 20, 40, 20);
        g2D.drawLine(35, 160, 188, 160);
        g2D.drawLine(185, 157, 188, 160);
        g2D.drawLine(185, 163, 188, 160);
        g2D.drawLine(180, 160, 180, 165);
        g2D.drawString("(2) Input", 110 - wInput / 2, 175 + hFont);
        g2D.drawLine(100, 100, 100, 50);
        g2D.drawLine(120, 80, 120, 50);
        g2D.setColor(PlaneSlicingPane.lineColor);
        g2D.setStroke(new BasicStroke(1.5f));
        g2D.drawLine(40, 160, 100, 100);
        g2D.drawLine(120, 80, 180, 20);
        g2D.setColor(PlaneSlicingPane.fixedLineColor);
        g2D.drawLine(101, 50, 120, 50);
        if (this.model.getPaneIndex() == 0) {
            g2D.setColor(PlaneSlicingPane.borderColor);
            g2D.draw(new Rectangle2D.Double(0.0, 0.0, 220.0, 200.0));
        } else {
            g2D.setColor(PlaneSlicingPane.layerColor);
            g2D.fillRect(0, 0, 220, 200);
        }
    }
}

