/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.cdm;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import ome.model.display.CodomainMapContext;
import ome.model.display.ContrastStretchingContext;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.util.cdm.CodomainMapContextDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.cdm.ContrastStretchingUI;
import org.openmicroscopy.shoola.util.ui.TitlePanel;

public class ContrastStretchingDialog
extends CodomainMapContextDialog
implements MouseListener,
MouseMotionListener {
    private static final String TITLE = "Contrast Stretching settings";
    private static final String TEXT = "Increase the dynamic range of the gray levels.";
    private static final int INPUT_START = 0;
    private static final int INPUT_END = 1;
    private static final int OUTPUT_START = 2;
    private static final int OUTPUT_END = 3;
    private boolean dragging;
    private Rectangle boxStart;
    private Rectangle boxEnd;
    private Rectangle boxOutputStart;
    private Rectangle boxOutputEnd;
    private int maxStartX;
    private int minEndX;
    private int maxStartOutputY;
    private int minEndOutputY;
    private int knobIndex;
    private int curValue;
    private ContrastStretchingUI uiDelegate;

    private void attachListeners() {
        this.uiDelegate.addMouseListener(this);
        this.uiDelegate.addMouseMotionListener(this);
    }

    private int convertGraphicsIntoReal(int x, int r, int b) {
        double a = (double)r / 140.0;
        return (int)(a * (double)x + (double)b);
    }

    private int convertRealIntoGraphics(int x, int r, int b) {
        double a = 140.0 / (double)r;
        return (int)(a * (double)(x - b));
    }

    private void setInputStartBox(int x) {
        this.maxStartX = x + 7;
        this.boxStart.setBounds(x - 7, 160, 14, 30);
    }

    private void setInputEndBox(int x) {
        this.minEndX = x - 7;
        this.boxEnd.setBounds(x - 7, 160, 14, 30);
    }

    private void setOutputStartBox(int y) {
        this.maxStartOutputY = y - 7;
        this.boxOutputStart.setBounds(0, y - 7, 32, 14);
    }

    private void setOutputEndBox(int y) {
        this.minEndOutputY = y + 7;
        this.boxOutputEnd.setBounds(0, y - 7, 32, 14);
    }

    private void setInputStart(int x) {
        this.uiDelegate.updateStartKnob(x);
        this.curValue = this.convertGraphicsIntoReal(x - 40, this.cdEnd - this.cdStart, this.cdStart);
    }

    private void setInputEnd(int x) {
        this.uiDelegate.updateEndKnob(x);
        this.curValue = this.convertGraphicsIntoReal(x - 40, this.cdEnd - this.cdStart, this.cdStart);
    }

    private void setOutputStart(int y) {
        this.uiDelegate.updateStartOutputKnob(y);
        this.curValue = this.convertGraphicsIntoReal(y - 20, this.cdStart - this.cdEnd, this.cdEnd);
    }

    private void setOutputEnd(int y) {
        this.uiDelegate.updateEndOutputKnob(y);
        this.curValue = this.convertGraphicsIntoReal(y - 20, this.cdStart - this.cdEnd, this.cdEnd);
    }

    private void initialize() {
        int diff = this.cdEnd - this.cdStart;
        ContrastStretchingContext csCtx = (ContrastStretchingContext)this.ctx;
        int xStart = 40 + this.convertRealIntoGraphics(csCtx.getXstart(), diff, this.cdStart);
        int xEnd = 40 + this.convertRealIntoGraphics(csCtx.getXend(), diff, this.cdStart);
        int yStart = 20 + this.convertRealIntoGraphics(csCtx.getYstart(), -diff, this.cdEnd);
        int yEnd = 20 + this.convertRealIntoGraphics(csCtx.getYend(), -diff, this.cdEnd);
        this.uiDelegate = new ContrastStretchingUI(xStart, xEnd, yStart, yEnd);
        this.setOutputEndBox(yEnd);
        this.setOutputStartBox(yStart);
        this.setInputStartBox(xStart);
        this.setInputEndBox(xEnd);
        this.attachListeners();
    }

    protected JComponent buildTitlePane() {
        return new TitlePanel(TITLE, TEXT, "[Note] The output interval selected in \"Mapping\" defines the input and output intervalsfor this transformation.", this.icons.getIcon(IconManager.CONTRAST_STRETCHING_BIG));
    }

    protected JComponent buildBody() {
        return this.uiDelegate;
    }

    protected void updateContext() {
        ContrastStretchingContext csCtx = (ContrastStretchingContext)this.ctx;
        switch (this.knobIndex) {
            case 0: {
                csCtx.setXstart(new Integer(this.curValue));
                break;
            }
            case 1: {
                csCtx.setXend(new Integer(this.curValue));
                break;
            }
            case 2: {
                csCtx.setYstart(new Integer(this.curValue));
                break;
            }
            case 3: {
                csCtx.setYend(new Integer(this.curValue));
            }
        }
    }

    protected void setWindowTitle() {
        this.setTitle(TITLE);
    }

    public ContrastStretchingDialog(JFrame owner, CodomainMapContext ctx, int cdEnd, int cdStart) {
        super(owner, ctx, cdEnd, cdStart);
        this.initialize();
        this.buildGUI();
    }

    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        if (!this.dragging) {
            this.dragging = true;
            if (this.boxStart.contains(p) && p.x >= 40 && p.x <= 180 && p.x <= this.minEndX) {
                this.knobIndex = 0;
                this.setInputStartBox(p.x);
                this.setInputStart(p.x);
            }
            if (this.boxEnd.contains(p) && p.x >= 40 && p.x <= 180 && p.x >= this.maxStartX) {
                this.knobIndex = 1;
                this.setInputEndBox(p.x);
                this.setInputEnd(p.x);
            }
            if (this.boxOutputStart.contains(p) && p.y >= this.minEndOutputY && p.y <= 160) {
                this.knobIndex = 2;
                this.setOutputStartBox(p.y);
                this.setOutputStart(p.y);
            }
            if (this.boxOutputEnd.contains(p) && p.y <= this.maxStartOutputY && p.y >= 20) {
                this.knobIndex = 3;
                this.setOutputEndBox(p.y);
                this.setOutputEnd(p.y);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        if (this.dragging) {
            if (this.boxStart.contains(p) && p.x >= 40 && p.x <= 180 && p.x <= this.minEndX) {
                this.setInputStartBox(p.x);
                this.setInputStart(p.x);
            }
            if (this.boxEnd.contains(p) && p.x >= 40 && p.x <= 180 && p.x >= this.maxStartX) {
                this.setInputEndBox(p.x);
                this.setInputEnd(p.x);
            }
            if (this.boxOutputStart.contains(p) && p.y >= this.minEndOutputY && p.y <= 160) {
                this.setOutputStartBox(p.y);
                this.setOutputStart(p.y);
            }
            if (this.boxOutputEnd.contains(p) && p.y <= this.maxStartOutputY && p.y >= 20) {
                this.setOutputEndBox(p.y);
                this.setOutputEnd(p.y);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.dragging = false;
        this.apply();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

