/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class InfoDialog
extends JDialog {
    public static final String UPDATE_PROPERTY = "update";
    private static final String TITLE = "Channel Info";
    private static final String TEXT = "Edit the selected channel";
    private static final Dimension H_BOX = new Dimension(10, 0);
    private JButton finishButton;
    private JButton cancelButton;
    private ChannelMetadata metadata;

    private void setDialogProperties() {
        this.setModal(true);
        this.setResizable(true);
        this.setTitle(TITLE);
    }

    private void initComponents() {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoDialog.this.close();
            }
        });
        this.finishButton = new JButton("Save");
        this.finishButton.setEnabled(false);
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoDialog.this.save();
            }
        });
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void save() {
        this.firePropertyChange(UPDATE_PROPERTY, null, this.metadata);
    }

    private JPanel buildToolBar() {
        JPanel toolBar = new JPanel();
        toolBar.add(this.finishButton);
        toolBar.add(Box.createRigidArea(H_BOX));
        toolBar.add(this.cancelButton);
        return toolBar;
    }

    private JPanel buildBody() {
        Map details = EditorUtil.transformChannelData(this.metadata);
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 3, 3, 3);
        Iterator i = details.keySet().iterator();
        while (i.hasNext()) {
            ++c.gridy;
            c.gridx = 0;
            String key = (String)i.next();
            String value = (String)details.get(key);
            JLabel label = UIUtilities.setTextFont(key);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            JTextField area = new JTextField(value);
            area.setEditable(false);
            area.setEnabled(false);
            label.setLabelFor(area);
            c.gridx = 1;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)area, c);
        }
        return content;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, TEXT, icons.getIcon(IconManager.INFO_48));
        c.add((Component)tp, "North");
        c.add((Component)this.buildBody(), "Center");
        c.add((Component)UIUtilities.buildComponentPanelRight(this.buildToolBar()), "South");
    }

    public InfoDialog(JFrame owner, ChannelMetadata metadata) {
        super(owner);
        if (metadata == null) {
            throw new IllegalArgumentException("No metadata");
        }
        this.metadata = metadata;
        this.setDialogProperties();
        this.initComponents();
        this.buildGUI();
        this.pack();
    }
}

