/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import org.openmicroscopy.shoola.agents.imviewer.util.ChannelButtonPopupMenu;
import org.openmicroscopy.shoola.util.ui.ColouredButton;

public class ChannelButton
extends ColouredButton
implements ActionListener {
    public static final Dimension DEFAULT_MIN_SIZE = new Dimension(30, 30);
    public static final String INFO_PROPERTY = "info";
    public static final String CHANNEL_SELECTED_PROPERTY = "channelSelected";
    public static final String CHANNEL_COLOR_PROPERTY = "channelColor";
    private final int index;
    private ChannelButtonPopupMenu popupMenu;

    private final void setChannelSelected() {
        Boolean value = Boolean.TRUE;
        if (this.isSelected()) {
            value = Boolean.FALSE;
        }
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>(1);
        map.put(new Integer(this.index), value);
        this.firePropertyChange(CHANNEL_SELECTED_PROPERTY, null, map);
    }

    private void onClick(MouseEvent e) {
        boolean mask;
        boolean bl = mask = e.isControlDown() || e.isMetaDown();
        if (e.getButton() == 1 && !mask) {
            this.singleClick();
        } else if (e.getButton() == 2 || mask) {
            this.onReleased(e);
        }
    }

    private void singleClick() {
        this.setChannelSelected();
    }

    private void onReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.popupMenu == null) {
                this.popupMenu = new ChannelButtonPopupMenu(this);
            }
            this.popupMenu.show(this, e.getX(), e.getY());
        }
    }

    public ChannelButton(String text, Color color, int index, boolean selected) {
        super(text, color);
        this.index = index;
        this.setSelected(selected);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ChannelButton.this.onClick(e);
            }

            public void mouseReleased(MouseEvent e) {
                ChannelButton.this.onReleased(e);
            }
        });
    }

    public ChannelButton(String text, Color color, int index) {
        this(text, color, index, false);
    }

    void showInfo() {
        this.firePropertyChange(INFO_PROPERTY, null, new Integer(this.index));
    }

    void showColorPicker() {
        this.firePropertyChange(CHANNEL_COLOR_PROPERTY, null, new Integer(this.index));
    }

    public int getChannelIndex() {
        return this.index;
    }

    public void actionPerformed(ActionEvent e) {
        this.singleClick();
    }
}

