/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.rnd.CodomainPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.ControlPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.DomainPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererModel;
import org.openmicroscopy.shoola.env.ui.TopWindow;

class RendererUI
extends TopWindow {
    static final Integer DOMAIN = new Integer(0);
    static final Integer CODOMAIN = new Integer(1);
    private RendererControl controller;
    private RendererModel model;
    private HashMap<Integer, ControlPane> controlPanes = new HashMap(2);

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createControlsMenu());
        return menuBar;
    }

    private JMenu createControlsMenu() {
        IconManager icons = IconManager.getInstance();
        JMenu menu = new JMenu("Controls");
        JMenuItem item = new JMenuItem(this.controller.getAction(RendererControl.SAVE_SETTINGS));
        item.setIcon(icons.getIcon(IconManager.SAVE_SETTINGS));
        menu.add(item);
        item = new JMenuItem(this.controller.getAction(RendererControl.RESET_SETTINGS));
        item.setIcon(icons.getIcon(IconManager.RESET_SETTINGS));
        menu.add(item);
        return menu;
    }

    private void createControlPanes() {
        ControlPane p = new DomainPane(this.model, this.controller);
        p.addPropertyChangeListener(this.controller);
        this.controlPanes.put(DOMAIN, p);
        p = new CodomainPane(this.model, this.controller);
        p.addPropertyChangeListener(this.controller);
        this.controlPanes.put(CODOMAIN, p);
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        JButton revertButton = new JButton(this.controller.getAction(RendererControl.RESET_SETTINGS));
        JButton acceptButton = new JButton(this.controller.getAction(RendererControl.SAVE_SETTINGS));
        p.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.anchor = 13;
        p.add((Component)acceptButton, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 0, 0, 14);
        p.add((Component)revertButton, gbc);
        return p;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        JTabbedPane tabs = new JTabbedPane(1, 0);
        tabs.setAlignmentX(0.0f);
        ControlPane pane = this.controlPanes.get(DOMAIN);
        tabs.insertTab(pane.getPaneName(), pane.getPaneIcon(), pane, pane.getPaneDescription(), pane.getPaneIndex());
        pane = this.controlPanes.get(CODOMAIN);
        tabs.insertTab(pane.getPaneName(), pane.getPaneIcon(), pane, pane.getPaneDescription(), pane.getPaneIndex());
        c.setLayout(new BorderLayout());
        c.add((Component)tabs, "North");
        c.add((Component)this.createButtonPanel(), "South");
    }

    RendererUI(String title) {
        super("Display Settings:  " + title);
    }

    void initialize(RendererControl controller, RendererModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.setJMenuBar(this.createMenuBar());
        this.createControlPanes();
        this.buildGUI();
        this.pack();
    }

    void addCodomainMap(Class mapType) {
        CodomainPane pane = (CodomainPane)this.controlPanes.get(CODOMAIN);
        pane.addCodomainMap(mapType);
    }

    void removeCodomainMap(Class mapType) {
        CodomainPane pane = (CodomainPane)this.controlPanes.get(CODOMAIN);
        pane.removeCodomainMap(mapType);
    }

    void setSelectedChannel(int c) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setSelectedChannel(c);
    }

    void setChannelButtonColor(int c) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setChannelButtonColor(c);
    }

    void setInputInterval() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setInputInterval();
    }

    void resetDefaultRndSettings() {
        Iterator<Integer> i = this.controlPanes.keySet().iterator();
        while (i.hasNext()) {
            ControlPane pane = this.controlPanes.get(i.next());
            pane.resetDefaultRndSettings();
        }
    }

    void setColorModelChanged() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setColorModelChanged();
    }

    void onCurveChange() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.onCurveChange();
    }
}

