/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import ome.model.display.CodomainMapContext;
import ome.model.display.ContrastStretchingContext;
import ome.model.display.PlaneSlicingContext;
import ome.model.display.ReverseIntensityContext;
import org.openmicroscopy.shoola.agents.imviewer.rnd.Renderer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;

class RendererModel {
    static final int CD_START = 0;
    static final int CD_END = 255;
    static final int DEPTH_1BIT = 1;
    static final int DEPTH_2BIT = 3;
    static final int DEPTH_3BIT = 7;
    static final int DEPTH_4BIT = 15;
    static final int DEPTH_5BIT = 31;
    static final int DEPTH_6BIT = 63;
    static final int DEPTH_7BIT = 127;
    static final int DEPTH_8BIT = 255;
    static final String LINEAR = "linear";
    static final String LOGARITHMIC = "logarithmic";
    static final String EXPONENTIAL = "exponential";
    static final String POLYNOMIAL = "polynomial";
    private ImViewer parentModel;
    private Renderer component;
    private RenderingControl rndControl;
    private int state;
    private int selectedChannelIndex;
    private boolean visible;

    RendererModel(ImViewer parentModel, RenderingControl rndControl) {
        if (parentModel == null) {
            throw new NullPointerException("No parent model.");
        }
        if (rndControl == null) {
            throw new NullPointerException("No rendering control.");
        }
        this.parentModel = parentModel;
        this.rndControl = rndControl;
        this.visible = false;
    }

    Color getChannelColor(int index) {
        return this.parentModel.getChannelColor(index);
    }

    boolean isVisible() {
        return this.visible;
    }

    void initialize(Renderer component) {
        this.component = component;
    }

    void discard() {
    }

    int getState() {
        return this.state;
    }

    void setInputInterval(double s, double e) throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.setChannelWindow(this.selectedChannelIndex, s, e);
    }

    int getCodomainEnd() {
        return this.rndControl.getCodomainEnd();
    }

    int getCodomainStart() {
        return this.rndControl.getCodomainStart();
    }

    void setCodomainInterval(int s, int e) throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.setCodomainInterval(s, e);
    }

    void setBitResolution(int v) throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.setQuantumStrategy(v);
    }

    void setSelectedChannel(int index) {
        this.selectedChannelIndex = index;
    }

    void setFamily(String family) throws RenderingServiceException, DSOutOfServiceException {
        boolean b = this.rndControl.getChannelNoiseReduction(this.selectedChannelIndex);
        double k = this.rndControl.getChannelCurveCoefficient(this.selectedChannelIndex);
        this.rndControl.setQuantizationMap(this.selectedChannelIndex, family, k, b);
    }

    void setCurveCoefficient(double k) throws RenderingServiceException, DSOutOfServiceException {
        boolean b = this.rndControl.getChannelNoiseReduction(this.selectedChannelIndex);
        String family = this.rndControl.getChannelFamily(this.selectedChannelIndex);
        this.rndControl.setQuantizationMap(this.selectedChannelIndex, family, k, b);
    }

    void setNoiseReduction(boolean b) throws RenderingServiceException, DSOutOfServiceException {
        String family = this.rndControl.getChannelFamily(this.selectedChannelIndex);
        double k = this.rndControl.getChannelCurveCoefficient(this.selectedChannelIndex);
        this.rndControl.setQuantizationMap(this.selectedChannelIndex, family, k, b);
    }

    void updateCodomainMap(CodomainMapContext ctx) throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.updateCodomainMap(ctx);
    }

    CodomainMapContext getCodomainMap(Class mapType) {
        List maps = this.getCodomainMaps();
        for (CodomainMapContext ctx : maps) {
            if (!ctx.getClass().equals(mapType)) continue;
            return ctx;
        }
        return null;
    }

    List getCodomainMaps() {
        return this.rndControl.getCodomainMaps();
    }

    ImViewer getParentModel() {
        return this.parentModel;
    }

    void removeCodomainMap(Class mapType) throws RenderingServiceException, DSOutOfServiceException {
        CodomainMapContext ctx = this.getCodomainMap(mapType);
        if (ctx != null) {
            this.rndControl.removeCodomainMap(ctx);
        }
    }

    void addCodomainMap(Class mapType) throws RenderingServiceException, DSOutOfServiceException {
        if (mapType.equals(ReverseIntensityContext.class)) {
            ReverseIntensityContext riCtx = new ReverseIntensityContext();
            riCtx.setReverse(Boolean.TRUE);
            this.rndControl.addCodomainMap((CodomainMapContext)riCtx);
        } else if (mapType.equals(PlaneSlicingContext.class) || mapType.equals(ContrastStretchingContext.class)) {
            // empty if block
        }
    }

    int getSelectedChannel() {
        return this.selectedChannelIndex;
    }

    List getFamilies() {
        return this.rndControl.getFamilies();
    }

    String getFamily() {
        return this.rndControl.getChannelFamily(this.selectedChannelIndex);
    }

    double getCurveCoefficient() {
        return this.rndControl.getChannelCurveCoefficient(this.selectedChannelIndex);
    }

    int getBitResolution() {
        return this.rndControl.getBitResolution();
    }

    boolean isNoiseReduction() {
        return this.rndControl.getChannelNoiseReduction(this.selectedChannelIndex);
    }

    ChannelMetadata[] getChannelData() {
        return this.rndControl.getChannelData();
    }

    double getGlobalMin() {
        return this.rndControl.getChannelData(this.selectedChannelIndex).getGlobalMin();
    }

    double getGlobalMax() {
        return this.rndControl.getChannelData(this.selectedChannelIndex).getGlobalMax();
    }

    double getWindowStart() {
        return this.rndControl.getChannelWindowStart(this.selectedChannelIndex);
    }

    double getWindowEnd() {
        return this.rndControl.getChannelWindowEnd(this.selectedChannelIndex);
    }

    void resetDefaultRndSettings() throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.resetDefaults();
        this.parentModel.resetDefaults();
    }

    String getColorModel() {
        return this.rndControl.getModel();
    }

    void saveRndSettings() throws RenderingServiceException, DSOutOfServiceException {
        this.rndControl.saveCurrentSettings();
    }

    boolean isChannelActive(int w) {
        return this.rndControl.isActive(w);
    }

    List getActiveChannels() {
        ArrayList<Integer> active = new ArrayList<Integer>();
        for (int i = 0; i < this.getMaxC(); ++i) {
            if (!this.rndControl.isActive(i)) continue;
            active.add(new Integer(i));
        }
        return active;
    }

    int getMaxC() {
        return this.rndControl.getPixelsDimensionsC();
    }

    void setRenderingControl(RenderingControl rndControl) {
        this.rndControl = rndControl;
    }
}

