/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import ome.model.display.CodomainMapContext;
import org.openmicroscopy.shoola.agents.imviewer.actions.ContrastStretchingAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.HistogramAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.NoiseReductionAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.PlaneSlicingAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ResetSettingsAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ReverseIntensityAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.RndAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.SaveSettingsAction;
import org.openmicroscopy.shoola.agents.imviewer.rnd.Renderer;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererUI;

class RendererControl
implements PropertyChangeListener {
    static final Integer SAVE_SETTINGS = new Integer(0);
    static final Integer RESET_SETTINGS = new Integer(1);
    static final Integer BIT_RESOLUTION = new Integer(2);
    static final Integer FAMILY = new Integer(3);
    static final Integer COEFFICIENT = new Integer(4);
    static final Integer NOISE_REDUCTION = new Integer(5);
    static final Integer REVERSE_INTENSITY = new Integer(6);
    static final Integer PLANE_SLICING = new Integer(7);
    static final Integer CONTRAST_STRETCHING = new Integer(8);
    static final Integer HISTOGRAM = new Integer(9);
    private Renderer model;
    private RendererUI view;
    private Map<Integer, RndAction> actionsMap = new HashMap<Integer, RndAction>();
    private boolean visibility;

    private void createActions() {
        this.actionsMap.put(REVERSE_INTENSITY, new ReverseIntensityAction(this.model));
        this.actionsMap.put(PLANE_SLICING, new PlaneSlicingAction(this.model));
        this.actionsMap.put(CONTRAST_STRETCHING, new ContrastStretchingAction(this.model));
        this.actionsMap.put(SAVE_SETTINGS, new SaveSettingsAction(this.model));
        this.actionsMap.put(RESET_SETTINGS, new ResetSettingsAction(this.model));
        this.actionsMap.put(NOISE_REDUCTION, new NoiseReductionAction(this.model));
        this.actionsMap.put(HISTOGRAM, new HistogramAction(this.model));
    }

    private void attachListeners() {
        this.model.addPropertyChangeListener(this);
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RendererControl.this.visibility = false;
                RendererControl.this.view.setVisible(false);
            }
        });
    }

    RendererControl() {
    }

    void initialize(Renderer model, RendererUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        model.getParentModel().addPropertyChangeListener(this);
        this.createActions();
        this.attachListeners();
    }

    Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void addPropertyListener(PropertyChangeListener observer) {
        this.model.addPropertyChangeListener(observer);
    }

    void setInputInterval(double s, double e, boolean released) {
        this.model.setInputInterval(s, e, released);
    }

    void setCodomainInterval(int s, int e, boolean released) {
        this.model.setCodomainInterval(s, e, released);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (!name.equals("zSelected") && !name.equals("tSelected")) {
            if (name.equals("updateMapContext")) {
                CodomainMapContext ctx = (CodomainMapContext)evt.getNewValue();
                this.model.updateCodomainMap(ctx);
            } else if (name.equals("family")) {
                String oldValue = (String)evt.getOldValue();
                String newValue = (String)evt.getNewValue();
                if (newValue.equals(oldValue)) {
                    return;
                }
                this.model.setFamily(newValue);
                this.view.onCurveChange();
            } else if (name.equals("gamma")) {
                Double oldValue = (Double)evt.getOldValue();
                Double newValue = (Double)evt.getNewValue();
                if (newValue.equals(oldValue)) {
                    return;
                }
                this.model.setCurveCoefficient(newValue);
                this.view.onCurveChange();
            } else if (name.equals("bit_resolution")) {
                Integer oldValue = (Integer)evt.getOldValue();
                Integer newValue = (Integer)evt.getNewValue();
                if (newValue.equals(oldValue)) {
                    return;
                }
                this.model.setBitResolution(newValue);
            } else if (name.equals("channelPicked")) {
                int v = (Integer)evt.getNewValue();
                this.model.setSelectedChannel(v, false);
            } else if (name.equals("channelActive")) {
                int v = (Integer)evt.getNewValue();
                this.model.setSelectedChannel(v, true);
            } else if (name.equals("iconified")) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    if (this.view.isVisible()) {
                        this.visibility = true;
                    }
                    this.view.setVisible(false);
                } else if (this.visibility) {
                    this.view.setVisible(true);
                }
            } else if (name.equals("inputInterval")) {
                this.view.setInputInterval();
            } else if (name.equals("channelColorChanged")) {
                int newValue = (Integer)evt.getNewValue();
                this.model.setChannelButtonColor(newValue);
            } else if (name.equals("colorModelChanged")) {
                this.model.setColorModelChanged();
            }
        }
    }

    void resizeRenderUI() {
        this.view.pack();
    }
}

