/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.util.List;
import javax.swing.JFrame;
import ome.model.display.CodomainMapContext;
import org.openmicroscopy.shoola.agents.imviewer.rnd.Renderer;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererUI;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class RendererComponent
extends AbstractComponent
implements Renderer {
    private RendererModel model;
    private RendererControl controller;
    private RendererUI view;

    private void setSelectedChannel(int oldChannel, int c) {
        if (oldChannel == c) {
            return;
        }
        this.model.setSelectedChannel(c);
        this.view.setSelectedChannel(c);
        this.firePropertyChange("selectedChannel", new Integer(oldChannel), new Integer(c));
    }

    RendererComponent(RendererModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new RendererControl();
        this.view = new RendererUI(this.getParentModel().getImageName());
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
    }

    public void discard() {
        this.model.discard();
        this.view.setVisible(false);
        this.view.dispose();
    }

    public void updateCodomainMap(CodomainMapContext ctx) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.updateCodomainMap(ctx);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().reload(ex);
        }
    }

    public void setInputInterval(double s, double e, boolean released) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setInputInterval(s, e);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
            this.firePropertyChange("inputInterval", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().reload(ex);
        }
    }

    public void setCodomainInterval(int s, int e, boolean released) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setCodomainInterval(s, e);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().reload(ex);
        }
    }

    public void setBitResolution(int v) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setBitResolution(v);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().reload(ex);
        }
    }

    public void setSelectedChannel(int c, boolean checkIfActive) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        int selectedChannel = this.model.getSelectedChannel();
        if (!checkIfActive) {
            this.setSelectedChannel(selectedChannel, c);
        } else {
            boolean active = this.model.isChannelActive(c);
            if (active) {
                this.setSelectedChannel(selectedChannel, c);
            } else {
                List actives = this.model.getActiveChannels();
                if (actives != null && actives.size() > 0) {
                    int maxC = this.model.getMaxC();
                    int index = c + 1;
                    int selected = -1;
                    while (selected == -1) {
                        if (actives.contains(new Integer(index))) {
                            selected = index;
                        }
                        if (index == maxC) {
                            index = 0;
                            continue;
                        }
                        ++index;
                    }
                    this.setSelectedChannel(selectedChannel, selected);
                }
            }
        }
    }

    public void setChannelButtonColor(int changedChannel) {
        this.view.setChannelButtonColor(changedChannel);
    }

    public void setColorModelChanged() {
        this.view.setColorModelChanged();
    }

    public void setFamily(String family) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setFamily(family);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().reload(ex);
        }
    }

    public void setCurveCoefficient(double k) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setCurveCoefficient(k);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().reload(ex);
        }
    }

    public void setNoiseReduction(boolean b) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setNoiseReduction(b);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().reload(ex);
        }
    }

    public int getState() {
        return this.model.getState();
    }

    public ImViewer getParentModel() {
        return this.model.getParentModel();
    }

    public CodomainMapContext getCodomainMapContext(Class mapType) {
        return this.model.getCodomainMap(mapType);
    }

    public void removeCodomainMap(Class mapType) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.removeCodomainMap(mapType);
            this.view.removeCodomainMap(mapType);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().reload(ex);
        }
    }

    public void addCodomainMap(Class mapType) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        if (this.model.getCodomainMap(mapType) != null) {
            return;
        }
        try {
            this.model.addCodomainMap(mapType);
            this.view.addCodomainMap(mapType);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().reload(ex);
        }
    }

    public double getWindowStart() {
        return this.model.getWindowStart();
    }

    public double getWindowEnd() {
        return this.model.getWindowEnd();
    }

    public double getGlobalMin() {
        return this.model.getGlobalMin();
    }

    public double getGlobalMax() {
        return this.model.getGlobalMax();
    }

    public void resetDefaultRndSettings() {
        try {
            this.model.resetDefaultRndSettings();
            this.view.resetDefaultRndSettings();
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().reload(ex);
        }
    }

    public JFrame getUI() {
        return this.view;
    }

    public void saveRndSettings() {
        try {
            this.model.saveRndSettings();
        }
        catch (Exception ex) {
            this.model.getParentModel().reload(ex);
        }
    }

    public void setRenderingControl(RenderingControl rndControl) {
        if (rndControl == null) {
            throw new IllegalArgumentException("No rendering control specified.");
        }
        this.model.setRenderingControl(rndControl);
    }
}

