/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.rnd.GraphicsPaneUI;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererModel;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;

class GraphicsPane
extends JPanel
implements ActionListener,
FocusListener,
PropertyChangeListener {
    private static final String PREVIEW = "Immediate Update";
    private static final int START_SELECTED = 0;
    private static final int END_SELECTED = 1;
    private TwoKnobsSlider codomainSlider;
    private TwoKnobsSlider domainSlider;
    private JTextField startField;
    private JTextField endField;
    private JLabel maxLabel;
    private JLabel minLabel;
    private GraphicsPaneUI uiDelegate;
    protected RendererModel model;
    protected RendererControl controller;
    private JCheckBox preview;
    private boolean paintLine;
    private int horizontalLine = -1;
    private int verticalLine = -1;

    private void initComponents() {
        this.uiDelegate = new GraphicsPaneUI(this, this.model);
        this.codomainSlider = new TwoKnobsSlider(0, 255, this.model.getCodomainStart(), this.model.getCodomainEnd());
        this.codomainSlider.setPaintLabels(false);
        this.codomainSlider.setPaintEndLabels(false);
        this.codomainSlider.setPaintTicks(false);
        this.codomainSlider.setOrientation(101);
        this.codomainSlider.addPropertyChangeListener(this);
        int s = (int)this.model.getWindowStart();
        int e = (int)this.model.getWindowEnd();
        this.domainSlider = new TwoKnobsSlider((int)this.model.getGlobalMin(), (int)this.model.getGlobalMax(), s, e);
        this.domainSlider.setPaintLabels(false);
        this.domainSlider.setPaintEndLabels(false);
        this.domainSlider.setPaintTicks(false);
        this.domainSlider.addPropertyChangeListener(this);
        double min = this.model.getGlobalMin();
        double max = this.model.getGlobalMax();
        this.startField = new JTextField();
        this.startField.setColumns(("" + min).length());
        this.endField = new JTextField();
        this.endField.setColumns(("" + max).length());
        this.startField.setText("" + s);
        this.endField.setText("" + e);
        this.startField.addActionListener(this);
        this.startField.setActionCommand("0");
        this.startField.addFocusListener(this);
        this.endField.addActionListener(this);
        this.endField.setActionCommand("1");
        this.endField.addFocusListener(this);
        this.maxLabel = new JLabel("" + (int)max);
        this.minLabel = new JLabel("" + (int)min);
        this.preview = new JCheckBox(PREVIEW);
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.buildGraphicsPane());
        this.add(this.buildFieldsControls());
    }

    private JPanel buildGraphicsPane() {
        JPanel p = new JPanel();
        int knobWidth = this.domainSlider.getKnobWidth();
        int knobHeight = this.domainSlider.getKnobHeight();
        int width = this.codomainSlider.getPreferredSize().width;
        double[][] size = new double[][]{{width, knobWidth / 2, -1.0, knobWidth / 2}, {knobHeight / 2, -1.0, knobHeight / 2, knobHeight + 2, -2.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        p.add((Component)this.codomainSlider, "0, 0, 0, 2");
        p.add((Component)this.uiDelegate, "2, 1");
        p.add((Component)this.domainSlider, "1, 3, 3, 3");
        p.add((Component)this.preview, "0, 4, 3, 4");
        return p;
    }

    private JPanel buildFieldsControls() {
        JPanel p = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        c.insets = new Insets(5, 20, 5, 30);
        c.anchor = 17;
        p.add((Component)this.buildFieldsPanel("Min", this.minLabel, "Start", this.startField), c);
        c.anchor = 13;
        c.gridx = 1;
        p.add((Component)this.buildFieldsPanel("Max", this.maxLabel, "End", this.endField), c);
        return p;
    }

    private JPanel buildFieldsPanel(String txt1, JLabel l, String txt2, JTextField f) {
        JPanel p = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 10, 5, 10);
        c.weightx = 60.0;
        c.anchor = 17;
        p.setLayout(new GridBagLayout());
        JLabel label = new JLabel(txt1);
        p.add((Component)label, c);
        c.gridx = 1;
        c.weightx = 40.0;
        c.anchor = 17;
        p.add((Component)l, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 60.0;
        label = new JLabel(txt2);
        c.anchor = 10;
        p.add((Component)label, c);
        c.gridx = 1;
        c.weightx = 40.0;
        p.add((Component)f, c);
        p.validate();
        return p;
    }

    private boolean startFieldValid() {
        double val = 0.0;
        double e = this.model.getWindowEnd();
        try {
            val = Double.parseDouble(this.startField.getText());
            return this.model.getGlobalMin() <= val && val < e;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private boolean endFieldValid() {
        double val = 0.0;
        double s = this.model.getWindowStart();
        try {
            val = Double.parseDouble(this.endField.getText());
            return s < val && val <= this.model.getGlobalMax();
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private void startSelectionHandler() {
        double e = this.model.getWindowEnd();
        double val = -1.0;
        try {
            val = Double.parseDouble(this.startField.getText());
        }
        catch (NumberFormatException nfe) {
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Invalid pixels intensity interval", " The value must be in the interval [" + (int)this.model.getWindowStart() + "," + (int)e + "]");
            return;
        }
        if (val == this.model.getWindowStart()) {
            return;
        }
        if (this.startFieldValid()) {
            this.controller.setInputInterval(val, e, true);
            this.onCurveChange();
        } else {
            this.startField.selectAll();
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Invalid pixels intensity interval", "The value must be in the interval [" + (int)val + "," + (int)e + "]");
        }
    }

    private void endSelectionHandler() {
        double s = this.model.getWindowStart();
        double val = -1.0;
        try {
            val = Double.parseDouble(this.endField.getText());
        }
        catch (NumberFormatException nfe) {
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Invalid pixels intensity interval", "The value must be in the interval [" + (int)s + "," + (int)this.model.getWindowEnd() + "]");
            return;
        }
        if (val == this.model.getWindowEnd()) {
            return;
        }
        if (this.endFieldValid()) {
            this.controller.setInputInterval(s, val, true);
            this.onCurveChange();
        } else {
            this.endField.selectAll();
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Invalid pixels intensity interval", "The value must be in the interval [" + (int)s + "," + (int)val + "]");
        }
    }

    GraphicsPane(RendererModel model, RendererControl controller) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (controller == null) {
            throw new NullPointerException("No controller.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedChannel() {
        int s = (int)this.model.getWindowStart();
        int e = (int)this.model.getWindowEnd();
        int min = (int)this.model.getGlobalMin();
        int max = (int)this.model.getGlobalMax();
        this.endField.setText("" + e);
        this.startField.setText("" + s);
        this.minLabel.setText("" + min);
        this.maxLabel.setText("" + max);
        this.domainSlider.setValues(max, min, s, e);
        this.onCurveChange();
    }

    void setInputInterval() {
        int s = (int)this.model.getWindowStart();
        int e = (int)this.model.getWindowEnd();
        this.endField.setText("" + e);
        this.startField.setText("" + s);
        this.domainSlider.setStartValue(s);
        this.domainSlider.setEndValue(e);
        this.onCurveChange();
    }

    void setCodomainInterval() {
        this.codomainSlider.setStartValue(this.model.getCodomainStart());
        this.codomainSlider.setEndValue(this.model.getCodomainEnd());
        this.onCurveChange();
    }

    void onCurveChange() {
        this.uiDelegate.invalidate();
        this.uiDelegate.repaint();
    }

    boolean isPaintLine() {
        return this.paintLine;
    }

    int getHorizontalLine() {
        return this.horizontalLine;
    }

    int getVerticalLine() {
        return this.verticalLine;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object source = evt.getSource();
        if (!this.preview.isSelected()) {
            if ("knobReleased".equals(name)) {
                this.paintLine = false;
                this.horizontalLine = -1;
                this.verticalLine = -1;
                if (source.equals(this.domainSlider)) {
                    this.controller.setInputInterval(this.domainSlider.getStartValue(), this.domainSlider.getEndValue(), true);
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    int s = this.codomainSlider.getStartValue();
                    int e = this.codomainSlider.getEndValue();
                    this.controller.setCodomainInterval(s, e, true);
                    this.onCurveChange();
                }
            }
            if ("leftMoved".equals(name)) {
                this.paintLine = true;
                if (source.equals(this.domainSlider)) {
                    this.verticalLine = this.domainSlider.getStartValue();
                    this.horizontalLine = -1;
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    this.horizontalLine = this.codomainSlider.getEndValue();
                    this.verticalLine = -1;
                    this.onCurveChange();
                }
            } else if ("rightMoved".equals(name)) {
                this.paintLine = true;
                if (source.equals(this.domainSlider)) {
                    this.verticalLine = this.domainSlider.getEndValue();
                    this.horizontalLine = -1;
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    this.horizontalLine = this.codomainSlider.getStartValue();
                    this.verticalLine = -1;
                    this.onCurveChange();
                }
            }
        } else {
            this.paintLine = false;
            this.horizontalLine = -1;
            this.verticalLine = -1;
            if ("leftMoved".equals(name) || "rightMoved".equals(name)) {
                if (source.equals(this.domainSlider)) {
                    this.controller.setInputInterval(this.domainSlider.getStartValue(), this.domainSlider.getEndValue(), true);
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    int s = this.codomainSlider.getStartValue();
                    int e = this.codomainSlider.getEndValue();
                    this.controller.setCodomainInterval(s, e, true);
                    this.onCurveChange();
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index = -1;
        try {
            index = Integer.parseInt(e.getActionCommand());
            switch (index) {
                case 0: {
                    this.startSelectionHandler();
                    break;
                }
                case 1: {
                    this.endSelectionHandler();
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + index, nfe);
        }
    }

    public void focusLost(FocusEvent fe) {
        if (fe.getSource() == this.startField) {
            if (this.startFieldValid()) {
                this.startSelectionHandler();
            } else {
                this.startField.setText("" + (int)this.model.getWindowStart());
            }
        }
        if (fe.getSource() == this.endField) {
            if (this.endFieldValid()) {
                this.endSelectionHandler();
            } else {
                this.endField.setText("" + this.model.getWindowEnd());
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }
}

