/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.rnd.ControlPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.GraphicsPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.imviewer.util.ChannelButton;
import org.openmicroscopy.shoola.agents.imviewer.util.ChannelToggleButton;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class DomainPane
extends ControlPane
implements ActionListener,
ChangeListener {
    static final int MIN_GAMMA = 1;
    static final int MAX_GAMMA = 40;
    static final int DEFAULT_GAMMA = 10;
    static final int MIN_BIT_DEPTH = 1;
    static final int MAX_BIT_DEPTH = 8;
    static final int DEFAULT_BIT_DEPTH = 8;
    private static final int FACTOR = 10;
    private static final int FAMILY = 0;
    private static final String SHOW_ADVANCED_OPTIONS = "Show Advanced Options";
    private static final String HIDE_ADVANCED_OPTIONS = "Hide Advanced Options";
    private static final Dimension VBOX = new Dimension(1, 10);
    private JComboBox familyBox;
    private List<ChannelToggleButton> channelList;
    private JPanel channelButtonPanel;
    private JPanel advancedPanel;
    private JSlider gammaSlider;
    private JSlider bitDepthSlider;
    private JTextField gammaLabel;
    private JTextField bitDepthLabel;
    private JCheckBox noiseReduction;
    private JButton histogramButton;
    private GraphicsPane graphicsPane;
    private JButton advancedOptionsButton;
    private boolean isAdvancedSettingsShowing;

    private void initComponents() {
        this.graphicsPane = new GraphicsPane(this.model, this.controller);
        this.familyBox = new JComboBox<Object>(this.model.getFamilies().toArray());
        String family = this.model.getFamily();
        this.familyBox.setSelectedItem(family);
        this.familyBox.addActionListener(this);
        this.familyBox.setActionCommand("0");
        double k = this.model.getCurveCoefficient();
        this.gammaSlider = new JSlider(0, 1, 40, (int)(k * 10.0));
        this.gammaSlider.setEnabled(!family.equals("linear") && !family.equals("logarithmic"));
        this.gammaSlider.addChangeListener(this);
        this.gammaLabel = new JTextField("" + k);
        this.gammaLabel.setEnabled(false);
        this.gammaLabel.setEditable(false);
        int v = this.model.getBitResolution();
        this.bitDepthSlider = new JSlider(0, 1, 8, this.convertBitResolution(v));
        this.bitDepthSlider.addChangeListener(this);
        this.bitDepthLabel = new JTextField("" + v);
        this.bitDepthLabel.setEnabled(false);
        this.bitDepthLabel.setEditable(false);
        this.noiseReduction = new JCheckBox();
        this.noiseReduction.setSelected(this.model.isNoiseReduction());
        this.noiseReduction.setAction(this.controller.getAction(RendererControl.NOISE_REDUCTION));
        this.histogramButton = new JButton(this.controller.getAction(RendererControl.HISTOGRAM));
        this.channelList = new ArrayList<ChannelToggleButton>();
        this.channelButtonPanel = this.createChannelButtons();
        this.isAdvancedSettingsShowing = false;
        this.advancedOptionsButton = new JButton(SHOW_ADVANCED_OPTIONS);
        this.advancedOptionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DomainPane.this.handleClick();
            }
        });
    }

    private void resetBitResolution() {
        int v = this.model.getBitResolution();
        this.bitDepthSlider.removeChangeListener(this);
        this.bitDepthSlider.setValue(this.convertBitResolution(v));
        this.bitDepthSlider.addChangeListener(this);
        this.bitDepthLabel.setText("" + v);
        this.bitDepthLabel.repaint();
    }

    private void handleClick() {
        if (this.isAdvancedSettingsShowing) {
            this.advancedOptionsButton.setText(SHOW_ADVANCED_OPTIONS);
            this.remove(this.advancedPanel);
        } else {
            this.advancedOptionsButton.setText(HIDE_ADVANCED_OPTIONS);
            this.add(this.advancedPanel);
        }
        this.controller.resizeRenderUI();
        this.isAdvancedSettingsShowing = !this.isAdvancedSettingsShowing;
    }

    private JPanel createChannelButtons() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        ChannelMetadata[] data = this.model.getChannelData();
        boolean gs = this.model.getColorModel().equals("greyscale");
        p.add(Box.createRigidArea(VBOX));
        for (int j = 0; j < data.length; ++j) {
            ChannelMetadata d = data[j];
            ChannelToggleButton item = new ChannelToggleButton("" + d.getEmissionWavelength(), this.model.getChannelColor(j), j);
            this.channelList.add(item);
            item.setSelected(this.model.getSelectedChannel() == j);
            item.setGrayedOut(gs);
            item.addPropertyChangeListener(this.controller);
            item.setPreferredSize(ChannelButton.DEFAULT_MIN_SIZE);
            item.setMinimumSize(ChannelButton.DEFAULT_MIN_SIZE);
            p.add(item);
            p.add(Box.createRigidArea(VBOX));
        }
        return UIUtilities.buildComponentPanel(p);
    }

    private JPanel buildChannelGraphicsPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.channelButtonPanel, "West");
        p.add((Component)this.graphicsPane, "Center");
        return p;
    }

    private JPanel buildSliderPane(JSlider slider, JTextField field) {
        JPanel p = new JPanel();
        p.add(slider);
        p.add(field);
        return UIUtilities.buildComponentPanel(p);
    }

    private JPanel buildControlsPane() {
        JPanel p = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        c.weightx = 0.5;
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        JLabel label = new JLabel("Map");
        c.gridx = 0;
        c.gridy = 1;
        p.add((Component)label, c);
        c.gridx = 1;
        p.add((Component)UIUtilities.buildComponentPanel(this.familyBox), c);
        label = new JLabel("Gamma");
        c.gridx = 0;
        c.gridy = 2;
        p.add((Component)label, c);
        c.gridx = 1;
        p.add((Component)this.buildSliderPane(this.gammaSlider, this.gammaLabel), c);
        label = new JLabel("Bit Depth");
        c.gridx = 0;
        c.gridy = 3;
        p.add((Component)label, c);
        c.gridx = 1;
        p.add((Component)this.buildSliderPane(this.bitDepthSlider, this.bitDepthLabel), c);
        return p;
    }

    private JPanel buildPane() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridy = 0;
        p.add((Component)this.noiseReduction, c);
        c.gridy = 1;
        p.add((Component)this.histogramButton, c);
        return UIUtilities.buildComponentPanel(p);
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.buildChannelGraphicsPanel());
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)this.advancedOptionsButton, "East");
        this.add(p);
        this.advancedPanel = new JPanel();
        this.advancedPanel.setLayout(new BoxLayout(this.advancedPanel, 1));
        this.advancedPanel.add(new JSeparator());
        this.advancedPanel.add(this.buildControlsPane());
        this.advancedPanel.add(new JSeparator());
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.buildPane());
        p.add(Box.createHorizontalStrut(200));
        this.advancedPanel.add(p);
        if (this.isAdvancedSettingsShowing) {
            this.add(this.advancedPanel);
        }
    }

    private int convertUIBitResolution(int uiValue) {
        switch (uiValue) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 15;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 63;
            }
            case 7: {
                return 127;
            }
        }
        return 255;
    }

    private int convertBitResolution(int value) {
        switch (value) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 15: {
                return 4;
            }
            case 31: {
                return 5;
            }
            case 63: {
                return 6;
            }
            case 127: {
                return 7;
            }
        }
        return 8;
    }

    private void resetGamma(double k) {
        this.gammaSlider.removeChangeListener(this);
        this.gammaSlider.setValue((int)(k * 10.0));
        this.gammaSlider.addChangeListener(this);
        this.gammaLabel.setText("" + k);
    }

    protected String getPaneName() {
        return "Mapping";
    }

    protected Icon getPaneIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(IconManager.DOMAIN);
    }

    protected String getPaneDescription() {
        return "Define the mapping context for the pixels intensity values.";
    }

    protected int getPaneIndex() {
        return 0;
    }

    protected void resetDefaultRndSettings() {
        this.setInputInterval();
        this.setSelectedChannel(this.model.getSelectedChannel());
        this.setCodomainInterval();
        this.resetBitResolution();
        boolean gs = this.model.getColorModel().equals("greyscale");
        for (int i = 0; i < this.channelList.size(); ++i) {
            ChannelToggleButton btn = this.channelList.get(i);
            btn.setColor(this.model.getChannelColor(btn.getChannelIndex()));
            btn.setGrayedOut(gs);
        }
        this.resetGamma(this.model.getCurveCoefficient());
    }

    DomainPane(RendererModel model, RendererControl controller) {
        super(model, controller);
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedChannel(int c) {
        this.graphicsPane.setSelectedChannel();
        String f = this.model.getFamily();
        this.familyBox.removeActionListener(this);
        this.familyBox.setSelectedItem(f);
        this.familyBox.addActionListener(this);
        boolean b = !f.equals("linear") && !f.equals("logarithmic");
        double k = 1.0;
        if (b) {
            k = this.model.getCurveCoefficient();
        }
        this.resetGamma(k);
        this.gammaSlider.setEnabled(b);
        this.noiseReduction.removeActionListener(this.controller.getAction(RendererControl.NOISE_REDUCTION));
        this.noiseReduction.setSelected(this.model.isNoiseReduction());
        this.noiseReduction.addActionListener(this.controller.getAction(RendererControl.NOISE_REDUCTION));
        this.noiseReduction.setText("Noise reduction");
        for (int i = 0; i < this.channelList.size(); ++i) {
            this.channelList.get(i).setSelected(i == c);
        }
    }

    void setInputInterval() {
        this.graphicsPane.setInputInterval();
    }

    void setCodomainInterval() {
        this.graphicsPane.setCodomainInterval();
    }

    void setChannelButtonColor(int c) {
        ChannelToggleButton btn = this.channelList.get(c);
        btn.setColor(this.model.getChannelColor(c));
        boolean gs = this.model.getColorModel().equals("greyscale");
        if (gs) {
            btn.setGrayedOut(gs);
        }
    }

    void setColorModelChanged() {
        String colorModel = this.model.getColorModel();
        for (int i = 0; i < this.channelList.size(); ++i) {
            ChannelToggleButton btn = this.channelList.get(i);
            btn.setColor(this.model.getChannelColor(i));
            btn.setGrayedOut(colorModel.equals("greyscale"));
        }
    }

    void onCurveChange() {
        String f = this.model.getFamily();
        boolean b = !f.equals("linear") && !f.equals("logarithmic");
        double k = 1.0;
        if (b) {
            k = this.model.getCurveCoefficient();
        }
        this.resetGamma(k);
        this.gammaSlider.setEnabled(b);
        this.graphicsPane.onCurveChange();
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source.equals(this.gammaSlider)) {
            double v = (double)this.gammaSlider.getValue() / 10.0;
            double oldValue = this.model.getCurveCoefficient();
            this.gammaLabel.setText("" + v);
            this.firePropertyChange("gamma", new Double(oldValue), new Double(v));
        } else if (source.equals(this.bitDepthSlider)) {
            int v = this.convertUIBitResolution(this.bitDepthSlider.getValue());
            int oldValue = this.model.getBitResolution();
            this.bitDepthLabel.setText("" + v);
            this.firePropertyChange("bit_resolution", new Integer(oldValue), new Integer(v));
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index = -1;
        index = Integer.parseInt(e.getActionCommand());
        try {
            switch (index) {
                case 0: {
                    String f = (String)((JComboBox)e.getSource()).getSelectedItem();
                    this.firePropertyChange("family", this.model.getFamily(), f);
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + index, nfe);
        }
    }
}

