/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import ome.model.display.CodomainMapContext;
import ome.model.display.ContrastStretchingContext;
import ome.model.display.PlaneSlicingContext;
import ome.model.display.ReverseIntensityContext;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.rnd.ControlPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererModel;

class CodomainPane
extends ControlPane {
    private JButton contrastStretchingButton;
    private JButton planeSlicingButton;
    private JCheckBox reverseIntensity;
    private JCheckBox contrastStretching;
    private JCheckBox planeSlicing;

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.contrastStretchingButton = new JButton(icons.getIcon(IconManager.CONTRAST_STRETCHING));
        this.contrastStretchingButton.setEnabled(false);
        this.contrastStretchingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.planeSlicingButton = new JButton(icons.getIcon(IconManager.PLANE_SLICING));
        this.planeSlicingButton.setEnabled(false);
        this.planeSlicingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.reverseIntensity = new JCheckBox(this.controller.getAction(RendererControl.REVERSE_INTENSITY));
        this.planeSlicing = new JCheckBox(this.controller.getAction(RendererControl.PLANE_SLICING));
        this.contrastStretching = new JCheckBox(this.controller.getAction(RendererControl.CONTRAST_STRETCHING));
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        List cdMaps = this.model.getCodomainMaps();
        for (CodomainMapContext ctx : cdMaps) {
            if (ctx instanceof ReverseIntensityContext) {
                this.reverseIntensity.setSelected(true);
                continue;
            }
            if (ctx instanceof ContrastStretchingContext) {
                this.contrastStretching.setSelected(true);
                this.contrastStretchingButton.setEnabled(true);
                continue;
            }
            if (!(ctx instanceof PlaneSlicingContext)) continue;
            this.planeSlicing.setSelected(true);
            this.planeSlicingButton.setEnabled(true);
        }
    }

    private JPanel buildControlsPane() {
        JPanel p = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(gridbag);
        c.fill = 2;
        c.anchor = 17;
        p.add((Component)this.reverseIntensity, c);
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 0;
        p.add((Component)this.contrastStretching, c);
        c.gridx = 1;
        c.anchor = 13;
        p.add((Component)this.contrastStretchingButton, c);
        c.gridy = 2;
        c.gridx = 0;
        c.anchor = 17;
        c.fill = 0;
        p.add((Component)this.planeSlicing, c);
        c.gridx = 1;
        c.anchor = 13;
        p.add((Component)this.planeSlicingButton, c);
        return p;
    }

    private void buildGUI() {
        this.add(this.buildControlsPane());
    }

    protected String getPaneName() {
        return "Device Settings";
    }

    protected Icon getPaneIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(IconManager.CODOMAIN);
    }

    protected String getPaneDescription() {
        return "Selects the transformations happening in the device space.";
    }

    protected int getPaneIndex() {
        return 1;
    }

    protected void resetDefaultRndSettings() {
        this.reverseIntensity.removeActionListener(this.controller.getAction(RendererControl.REVERSE_INTENSITY));
        this.planeSlicing.removeActionListener(this.controller.getAction(RendererControl.PLANE_SLICING));
        this.contrastStretching.removeActionListener(this.controller.getAction(RendererControl.CONTRAST_STRETCHING));
        this.setDefaultValues();
        this.reverseIntensity.setAction(this.controller.getAction(RendererControl.REVERSE_INTENSITY));
        this.planeSlicing.setAction(this.controller.getAction(RendererControl.PLANE_SLICING));
        this.contrastStretching.setAction(this.controller.getAction(RendererControl.CONTRAST_STRETCHING));
    }

    CodomainPane(RendererModel model, RendererControl controller) {
        super(model, controller);
        this.initComponents();
        this.buildGUI();
    }

    void addCodomainMap(Class mapType) {
        if (mapType.equals(PlaneSlicingContext.class)) {
            this.planeSlicingButton.setEnabled(true);
        } else if (mapType.equals(ContrastStretchingContext.class)) {
            this.contrastStretchingButton.setEnabled(true);
        }
    }

    void removeCodomainMap(Class mapType) {
        if (mapType.equals(PlaneSlicingContext.class)) {
            this.planeSlicingButton.setEnabled(false);
        } else if (mapType.equals(ContrastStretchingContext.class)) {
            this.contrastStretchingButton.setEnabled(false);
        }
    }
}

