/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.ImageCanvas;

class ImageCanvasListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private BrowserModel model;
    private ImageCanvas canvas;
    private boolean mouseOnCanvas;
    private Rectangle area;

    ImageCanvasListener(BrowserModel model, ImageCanvas canvas) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (canvas == null) {
            throw new NullPointerException("No canvas.");
        }
        this.model = model;
        this.canvas = canvas;
        this.area = new Rectangle(0, 0, 0, 0);
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        canvas.addMouseWheelListener(this);
    }

    void setAreaSize(int width, int height) {
        this.area.setBounds(0, 0, width, height);
    }

    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        int pressedZ = -1;
        int pressedT = -1;
        int maxZ = this.model.getMaxZ();
        pressedZ = p.y * maxZ / this.area.height;
        if (pressedZ < 0) {
            return;
        }
        if ((pressedZ = maxZ - pressedZ) > this.model.getMaxZ()) {
            pressedZ = -1;
        }
        if ((pressedT = p.x * this.model.getMaxT() / this.area.width) < 0) {
            return;
        }
        if (pressedT > this.model.getMaxT()) {
            return;
        }
        this.model.setSelectedXYPlane(pressedZ, pressedT);
        this.canvas.setPaintedString(pressedZ, pressedT);
    }

    public void mousePressed(MouseEvent e) {
        this.canvas.setPaintedString(this.model.getDefaultZ(), this.model.getDefaultT());
    }

    public void mouseReleased(MouseEvent e) {
        this.canvas.setPaintedString(-1, -1);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.mouseOnCanvas) {
            return;
        }
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultZ() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getMaxZ()) {
                    this.model.setSelectedXYPlane(v, -1);
                    this.canvas.setPaintedString(v, this.model.getDefaultT());
                } else {
                    this.canvas.setPaintedString(-1, -1);
                }
            } else if (v >= 0) {
                this.model.setSelectedXYPlane(v, -1);
                this.canvas.setPaintedString(v, this.model.getDefaultT());
            } else {
                this.canvas.setPaintedString(-1, -1);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseOnCanvas = this.area.contains(e.getPoint());
    }

    public void mouseExited(MouseEvent e) {
        this.mouseOnCanvas = false;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

