/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.GridCanvas;

class GridUI
extends JScrollPane {
    private GridCanvas canvas;
    private BrowserModel model;
    private JLayeredPane layeredPane;

    private void initComponents() {
        this.layeredPane = new JLayeredPane();
        this.canvas = new GridCanvas(this.model);
        this.layeredPane.add((Component)this.canvas, new Integer(0));
    }

    private void buildGUI() {
        this.getViewport().setLayout(null);
        this.getViewport().setBackground(this.model.getBackgroundColor());
        this.getViewport().add(this.layeredPane);
    }

    GridUI() {
    }

    void initialize(BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void setGridSize() {
        Dimension d = this.model.getGridSize();
        this.layeredPane.setPreferredSize(d);
        this.layeredPane.setSize(d);
        this.canvas.setPreferredSize(d);
        this.canvas.setSize(d);
    }

    void addComponentToLayer(JComponent c) {
        this.layeredPane.add((Component)c, new Integer(1));
    }

    void removeComponentFromLayer(JComponent c) {
        this.layeredPane.remove(c);
    }

    void paintImage() {
        this.repaint();
    }

    BufferedImage getGridImage() {
        return this.canvas.getGridImage();
    }

    Point isOnImageInGrid(Rectangle rect) {
        return this.canvas.isOnImageInGrid(rect);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Rectangle r = this.getViewport().getViewRect();
        Dimension d = this.layeredPane.getPreferredSize();
        int xLoc = (r.width - d.width) / 2;
        int yLoc = (r.height - d.height) / 2;
        if (xLoc < 0) {
            xLoc = 0;
        }
        if (yLoc < 0) {
            yLoc = 0;
        }
        this.layeredPane.setLocation(xLoc, yLoc);
    }
}

