/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.ImageCanvas;
import org.openmicroscopy.shoola.agents.imviewer.browser.SplitImage;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;

class GridCanvas
extends ImageCanvas {
    private void paintImage(Graphics2D g2D, int w, int h, boolean bar) {
        int textWidth;
        BufferedImage image;
        List images = this.model.getGridImages();
        if (images == null) {
            return;
        }
        SplitImage combined = null;
        g2D.setColor(this.model.getBackgroundColor());
        Dimension d = this.getSize();
        g2D.fillRect(0, 0, d.width, d.height);
        int n = this.model.getMaxC() + 1;
        if (n <= 3) {
            n = 4;
        }
        if (n > 4 && n % 2 != 0) {
            combined = (SplitImage)images.get(images.size() - 1);
            images.remove(images.size() - 1);
        }
        n = (int)Math.floor(Math.sqrt(n));
        Iterator channels = images.iterator();
        int x = 0;
        int y = 0;
        String v = this.model.getUnitBarValue();
        int s = (int)(this.model.getUnitBarSize() * this.model.getRatio());
        Color c = this.model.getUnitBarColor();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        boolean text = this.model.isTextVisible();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!channels.hasNext()) {
                    return;
                }
                SplitImage channel = (SplitImage)channels.next();
                image = channel.getImage();
                x = j * (w + 2);
                if (image != null) {
                    g2D.drawImage(image, null, x, y);
                    if (text) {
                        textWidth = fm.stringWidth(channel.getName());
                        g2D.setColor(BACKGROUND);
                        g2D.fillRect(x, y, textWidth + 4, 3 * this.height / 2);
                        g2D.setColor(this.getBackground());
                        g2D.drawString(channel.getName(), x + 2, y + this.height);
                    }
                    if (!bar || v == null || s >= w) continue;
                    ImagePaintingFactory.paintScaleBar(g2D, x + w - s - 5, y + h - 5, s, v, c);
                    continue;
                }
                if (!text) continue;
                g2D.setColor(BACKGROUND);
                g2D.drawRect(x, y, w - 1, h - 1);
                g2D.drawString(channel.getName(), x + 2, y + this.height);
            }
            x = 0;
            y = (i + 1) * (h + 2);
        }
        if (combined != null) {
            image = combined.getImage();
            y = 0;
            x = n * (w + 2);
            if (image != null) {
                g2D.drawImage(image, null, x, y);
                if (text) {
                    textWidth = fm.stringWidth(combined.getName());
                    g2D.setColor(BACKGROUND);
                    g2D.fillRect(x, y, textWidth + 4, 3 * this.height / 2);
                    g2D.setColor(this.getBackground());
                    g2D.drawString(combined.getName(), x + 2, y + this.height);
                }
                if (bar && v != null && s < w) {
                    ImagePaintingFactory.paintScaleBar(g2D, x + w - s - 5, y + h - 5, s, v, c);
                }
            }
        }
    }

    GridCanvas(BrowserModel model) {
        super(model);
    }

    BufferedImage getGridImage() {
        BufferedImage original = this.model.getAnnotateImage();
        int w = original.getWidth();
        int h = original.getHeight();
        Dimension d = this.getSize();
        BufferedImage gridImage = new BufferedImage(d.width, d.height, 1);
        Graphics2D g2D = (Graphics2D)gridImage.getGraphics();
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        this.paintImage(g2D, w, h, this.model.isUnitBar());
        return gridImage;
    }

    Point isOnImageInGrid(Rectangle r) {
        Rectangle imageRectangle;
        BufferedImage image;
        List images = this.model.getGridImages();
        if (images == null) {
            return null;
        }
        SplitImage combined = null;
        int n = images.size();
        if (n <= 3) {
            n = 4;
        }
        if (n > 4 && n % 2 != 0) {
            combined = (SplitImage)images.get(images.size() - 1);
            images.remove(images.size() - 1);
        }
        n = (int)Math.floor(Math.sqrt(n));
        Iterator channels = images.iterator();
        int x = 0;
        int y = 0;
        BufferedImage original = this.model.getAnnotateImage();
        int w = original.getWidth();
        int h = original.getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n && channels.hasNext(); ++j) {
                SplitImage channel = (SplitImage)channels.next();
                image = channel.getImage();
                x = j * (w + 2);
                if (image == null || !(imageRectangle = new Rectangle(x, y, w, h)).contains(r)) continue;
                return new Point(r.x - imageRectangle.x, r.y - imageRectangle.y);
            }
            x = 0;
            y = (i + 1) * (h + 2);
        }
        if (combined != null) {
            image = combined.getImage();
            y = 0;
            x = n * (w + 2);
            if (image != null && (imageRectangle = new Rectangle(x, y, w, h)).contains(r)) {
                return new Point(r.x - imageRectangle.x, r.y - imageRectangle.y);
            }
            return null;
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        BufferedImage original = this.model.getAnnotateImage();
        this.paintImage(g2D, original.getWidth(), original.getHeight(), this.model.isUnitBar());
    }
}

