/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserCanvas;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.ImageCanvasListener;

class BrowserUI
extends JScrollPane {
    private JLayeredPane layeredPane;
    private BrowserCanvas browserCanvas;
    private BrowserModel model;
    private BrowserControl controller;
    private ImageCanvasListener canvasListener;

    private void initComponents() {
        this.layeredPane = new JLayeredPane();
        this.browserCanvas = new BrowserCanvas(this.model, this);
        this.layeredPane.add((Component)this.browserCanvas, new Integer(0));
        this.canvasListener = new ImageCanvasListener(this.model, this.browserCanvas);
    }

    private void buildGUI() {
        this.getViewport().setLayout(null);
        this.getViewport().setBackground(this.model.getBackgroundColor());
        this.getViewport().add(this.layeredPane);
    }

    BrowserUI() {
    }

    void initialize(BrowserControl controller, BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void addComponentToLayer(JComponent c) {
        Component[] components = this.layeredPane.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != c) continue;
            return;
        }
        this.layeredPane.add((Component)c, new Integer(1));
    }

    void removeComponentFromLayer(JComponent c) {
        this.layeredPane.remove(c);
    }

    void paintImage() {
        if (this.model.getRenderedImage() == null) {
            return;
        }
        this.model.createDisplayedImage();
        BufferedImage img = this.model.getDisplayedImage();
        this.canvasListener.setAreaSize(img.getWidth(), img.getHeight());
        this.browserCanvas.repaint();
    }

    void zoomImage() {
        if (this.model.getRenderedImage() == null) {
            return;
        }
        this.model.createDisplayedImage();
        BufferedImage img = this.model.getDisplayedImage();
        this.setComponentsSize(img.getWidth(), img.getHeight());
        this.canvasListener.setAreaSize(img.getWidth(), img.getHeight());
        this.getViewport().setViewPosition(new Point(-1, -1));
        this.browserCanvas.repaint();
        this.setBounds(this.getBounds());
    }

    void setComponentsSize(int w, int h) {
        Dimension d = new Dimension(w, h);
        this.layeredPane.setPreferredSize(d);
        this.layeredPane.setSize(d);
        this.browserCanvas.setPreferredSize(d);
        this.browserCanvas.setSize(d);
    }

    Dimension getCurrentViewport() {
        return this.getViewport().getSize();
    }

    void scrollTo(Rectangle bounds, boolean blockIncrement) {
        Rectangle viewRect = this.getViewport().getViewRect();
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        int x = 0;
        int y = 0;
        if (!viewRect.contains(bounds)) {
            int deltaX = viewRect.x - bounds.x;
            int deltaY = viewRect.y - bounds.y;
            if (deltaX < 0 && blockIncrement) {
                x = hBar.getValue() + hBar.getBlockIncrement();
            } else {
                int w = viewRect.width - bounds.width;
                if (w < 0) {
                    w = -w;
                }
                x = bounds.x - w / 2;
            }
            if (deltaY < 0 && blockIncrement) {
                y = vBar.getValue() + vBar.getBlockIncrement();
            } else {
                int h = viewRect.height - bounds.height;
                if (h < 0) {
                    h = -h;
                }
                y = bounds.y - h / 2;
            }
        } else {
            if (blockIncrement) {
                return;
            }
            int w = viewRect.width - bounds.width;
            if (w < 0) {
                w = -w;
            }
            x = bounds.x - w / 2;
            int h = viewRect.height - bounds.height;
            if (h < 0) {
                h = -h;
            }
            y = bounds.y - h / 2;
        }
        vBar.setValue(y);
        hBar.setValue(x);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Rectangle r = this.getViewport().getViewRect();
        Dimension d = this.layeredPane.getPreferredSize();
        int xLoc = (r.width - d.width) / 2;
        int yLoc = (r.height - d.height) / 2;
        this.layeredPane.setBounds(xLoc, yLoc, d.width, d.height);
    }
}

