/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.UnitBarSizeAction;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.browser.SplitImage;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;
import sun.awt.image.IntegerInterleavedRaster;

class BrowserModel {
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int BLANK_MASK = 0;
    private static final String COMBINED = "Combined";
    private static final String PREFIX = "w=";
    static final int GAP = 2;
    private static final String TITLE = "View";
    private static final String TITLE_ANNOTATOR = "Annotation";
    private static final String TITLE_GRIDVIEW = "Split";
    private static final int MINIMUM_SIZE = 96;
    private static final double RATIO = 0.5;
    private Browser component;
    private BufferedImage renderedImage;
    private BufferedImage displayedImage;
    private BufferedImage annotateImage;
    private double zoomFactor;
    private ImViewer parent;
    private boolean unitBar;
    private double unitInMicrons;
    private Color unitBarColor;
    private Color backgroundColor;
    private ImageData data;
    private List<BufferedImage> gridImages;
    private List<SplitImage> splitImages;
    private double ratio;
    private boolean init;

    private BufferedImage createBandImage(DataBuffer buf, int sizeX, int sizeY, int redMask, int greenMask, int blueMask) {
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, sizeX, sizeY, sizeX, new int[]{redMask, greenMask, blueMask});
        IntegerInterleavedRaster raster = new IntegerInterleavedRaster((SampleModel)sampleModel, buf, new Point(0, 0));
        DirectColorModel colorModel = new DirectColorModel(32, redMask, greenMask, blueMask);
        return new BufferedImage(colorModel, raster, false, null);
    }

    BrowserModel(ImViewer parent, long imageID) {
        if (parent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.data = new ImageData();
        this.data.setId(imageID);
        this.parent = parent;
        this.unitBar = true;
        this.ratio = 0.5;
        this.init = true;
        this.unitInMicrons = UnitBarSizeAction.getDefaultValue();
        this.unitBarColor = ImagePaintingFactory.UNIT_BAR_COLOR;
        this.backgroundColor = ImagePaintingFactory.DEFAULT_BACKGROUND;
        this.gridImages = new ArrayList<BufferedImage>();
        this.zoomFactor = 1.0;
    }

    void initialize(Browser component) {
        this.component = component;
    }

    void setRenderedImage(BufferedImage image) {
        this.renderedImage = image;
        if (this.renderedImage != null) {
            if (this.init) {
                if (image.getWidth() < 96) {
                    this.ratio = 1.0;
                    this.unitBar = false;
                }
                this.init = false;
            }
            this.annotateImage = Factory.magnifyImage(this.ratio, this.renderedImage);
        } else {
            this.annotateImage = null;
        }
        this.displayedImage = null;
        this.gridImages.clear();
    }

    void setGridImages() {
        if (this.gridImages.size() != 0) {
            return;
        }
        this.gridImages.clear();
        List l = this.parent.getActiveChannels();
        int maxC = this.parent.getMaxC();
        List images = new ArrayList(maxC);
        if (l.size() <= 3 && !this.parent.getColorModel().equals("greyscale")) {
            int w = this.annotateImage.getWidth();
            int h = this.annotateImage.getHeight();
            DataBuffer buf = this.annotateImage.getRaster().getDataBuffer();
            for (int i = 0; i < maxC; ++i) {
                if (this.parent.isChannelActive(i)) {
                    if (this.parent.isChannelRed(i)) {
                        this.gridImages.add(this.createBandImage(buf, w, h, 0xFF0000, 0, 0));
                        continue;
                    }
                    if (this.parent.isChannelGreen(i)) {
                        this.gridImages.add(this.createBandImage(buf, w, h, 0, 65280, 0));
                        continue;
                    }
                    if (this.parent.isChannelBlue(i)) {
                        this.gridImages.add(this.createBandImage(buf, w, h, 0, 0, 255));
                        continue;
                    }
                    this.gridImages.add(this.parent.getImageForGrid(i));
                    continue;
                }
                this.gridImages.add(null);
            }
            return;
        }
        images = this.parent.getGridImages();
        if (images != null) {
            Iterator i = images.iterator();
            while (i.hasNext()) {
                this.gridImages.add(Factory.magnifyImage(this.ratio, (BufferedImage)i.next()));
            }
        }
    }

    BufferedImage getDisplayedImage() {
        return this.displayedImage;
    }

    BufferedImage getRenderedImage() {
        return this.renderedImage;
    }

    void setZoomFactor(double factor) {
        this.zoomFactor = factor;
    }

    double getZoomFactor() {
        return this.zoomFactor;
    }

    String getTitle() {
        return TITLE;
    }

    Icon getIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(IconManager.VIEWER);
    }

    void createDisplayedImage() {
        if (this.renderedImage == null) {
            return;
        }
        this.displayedImage = this.zoomFactor != 1.0 ? Factory.magnifyImage(this.renderedImage, this.zoomFactor, 0) : this.renderedImage;
    }

    int getMaxZ() {
        return this.parent.getMaxZ();
    }

    int getMaxT() {
        return this.parent.getMaxT();
    }

    float getPixelsSizeX() {
        return this.parent.getPixelsSizeX();
    }

    boolean isUnitBar() {
        return this.unitBar;
    }

    void setUnitBar(boolean unitBar) {
        this.unitBar = unitBar;
    }

    void setUnitBarSize(double size) {
        this.unitInMicrons = size;
    }

    double getUnitInMicrons() {
        return this.unitInMicrons;
    }

    double getUnitBarSize() {
        double v = this.unitInMicrons;
        if (this.getPixelsSizeX() > 0.0f) {
            v = this.unitInMicrons / (double)this.getPixelsSizeX();
        }
        return v *= this.zoomFactor;
    }

    String getUnitBarValue() {
        return UIUtilities.twoDecimalPlaces(this.unitInMicrons);
    }

    Color getUnitBarColor() {
        return this.unitBarColor;
    }

    void setUnitBarColor(Color c) {
        this.unitBarColor = c;
    }

    Color getBackgroundColor() {
        return this.backgroundColor;
    }

    void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    ImageData getImageData() {
        return this.data;
    }

    String getAnnotatorTitle() {
        return TITLE_ANNOTATOR;
    }

    String getGridViewTitle() {
        return TITLE_GRIDVIEW;
    }

    Icon getGridViewIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(IconManager.GRIDVIEW);
    }

    Icon getAnnotatorIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(IconManager.ANNOTATION);
    }

    BufferedImage getAnnotateImage() {
        return this.annotateImage;
    }

    void setSelectedXYPlane(int z, int t) {
        if (z < 0) {
            z = this.parent.getDefaultZ();
        }
        if (t < 0) {
            t = this.parent.getDefaultT();
        }
        this.parent.setSelectedXYPlane(z, t);
    }

    int getDefaultT() {
        return this.parent.getDefaultT();
    }

    int getDefaultZ() {
        return this.parent.getDefaultZ();
    }

    int getMaxX() {
        return this.parent.getMaxX();
    }

    int getMaxY() {
        return this.parent.getMaxY();
    }

    float getPixelsSizeY() {
        return this.parent.getPixelsSizeY();
    }

    float getPixelsSizeZ() {
        return this.parent.getPixelsSizeZ();
    }

    Dimension getGridSize() {
        int w = (int)((double)this.getMaxX() * this.ratio);
        int h = (int)((double)this.getMaxY() * this.ratio);
        int n = this.parent.getMaxC() + 1;
        if (n <= 3) {
            n = 4;
        }
        int index = 0;
        if (n % 2 != 0) {
            index = 1;
        }
        int col = (int)Math.floor(Math.sqrt(n)) + index;
        int row = n / col + index;
        return new Dimension(col * w + (col - 1) * 2, row * h + (row - 1) * 2);
    }

    boolean hasNoGridImages() {
        return this.gridImages.size() == 0;
    }

    List getGridImages() {
        if (this.splitImages == null) {
            this.splitImages = new ArrayList<SplitImage>();
        } else {
            this.splitImages.clear();
        }
        boolean grey = this.parent.getColorModel().equals("greyscale");
        BufferedImage combined = this.annotateImage;
        int length = this.gridImages.size();
        if (grey) {
            combined = this.gridImages.get(--length);
        }
        for (int j = 0; j < length; ++j) {
            String n = PREFIX + this.parent.getChannelMetadata(j).getEmissionWavelength();
            this.splitImages.add(new SplitImage(this.gridImages.get(j), n));
        }
        this.splitImages.add(new SplitImage(combined, COMBINED));
        return this.splitImages;
    }

    int getSelectedIndex() {
        return this.parent.getSelectedIndex();
    }

    boolean isTextVisible() {
        return this.parent.isTextVisible();
    }

    double getRatio() {
        return this.ratio;
    }

    int getMaxC() {
        return this.parent.getMaxC();
    }
}

