/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.browser.AnnotatorUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.GridUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class BrowserComponent
extends AbstractComponent
implements Browser {
    private BrowserModel model;
    private BrowserControl controller;
    private BrowserUI view;
    private AnnotatorUI annotator;
    private GridUI gridView;

    BrowserComponent(BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new BrowserControl();
        this.view = new BrowserUI();
        this.annotator = new AnnotatorUI();
        this.gridView = new GridUI();
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
        this.annotator.initialize(this.controller, this.model);
        this.gridView.initialize(this.model);
    }

    public JComponent getUI() {
        return this.view;
    }

    public void setRenderedImage(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null.");
        }
        this.model.setRenderedImage(image);
        this.view.paintImage();
        this.annotator.paintImage();
        this.viewSplitImages();
    }

    public BufferedImage getDisplayedImage() {
        return this.model.getDisplayedImage();
    }

    public BufferedImage getRenderedImage() {
        return this.model.getRenderedImage();
    }

    public void removeComponent(JComponent c, int index) {
        if (c == null) {
            throw new IllegalArgumentException("Component cannot be null.");
        }
        switch (index) {
            case 0: {
                this.view.removeComponentFromLayer(c);
                break;
            }
            case 2: {
                this.gridView.removeComponentFromLayer(c);
                break;
            }
            case 1: {
                this.annotator.removeComponentFromLayer(c);
            }
        }
    }

    public void addComponent(JComponent c, int index) {
        if (c == null) {
            throw new IllegalArgumentException("Component cannot be null.");
        }
        switch (index) {
            case 0: {
                this.view.addComponentToLayer(c);
                break;
            }
            case 2: {
                this.gridView.addComponentToLayer(c);
                break;
            }
            case 1: {
                this.annotator.addComponentToLayer(c);
            }
        }
    }

    public void setZoomFactor(double factor) {
        if (factor != -1.0) {
            if (factor > 3.0 || factor < 0.25) {
                throw new IllegalArgumentException("The zoom factor is value between 0.25 and 3.0");
            }
        } else {
            BufferedImage img = this.model.getRenderedImage();
            int width = img.getWidth();
            int height = img.getHeight();
            Dimension viewport = this.view.getCurrentViewport();
            double zoomFactorX = 0.0;
            if (width > 0) {
                zoomFactorX = viewport.getWidth() / (double)width;
            }
            double zoomFactorY = 0.0;
            if (height > 0) {
                zoomFactorY = viewport.getHeight() / (double)height;
            }
            factor = Math.min(zoomFactorX, zoomFactorY);
        }
        this.model.setZoomFactor(factor);
        this.view.zoomImage();
    }

    public double getZoomFactor() {
        return this.model.getZoomFactor();
    }

    public String getTitle() {
        return this.model.getTitle();
    }

    public Icon getIcon() {
        return this.model.getIcon();
    }

    public void setComponentsSize(int w, int h) {
        this.view.setComponentsSize(w, h);
        this.view.setPreferredSize(new Dimension(w + 5, h + 5));
        this.gridView.setGridSize();
    }

    public void setUnitBar(boolean b) {
        if (b == this.model.isUnitBar()) {
            return;
        }
        this.model.setUnitBar(b);
        this.view.repaint();
        if (this.model.getSelectedIndex() == 2) {
            this.gridView.repaint();
        }
    }

    public void setUnitBarSize(double size) {
        double oldUnit = this.model.getUnitInMicrons();
        this.model.setUnitBarSize(size);
        Rectangle viewRect = this.view.getViewport().getBounds();
        if ((double)viewRect.width >= this.model.getUnitBarSize()) {
            this.view.repaint();
            if (this.model.getSelectedIndex() == 2) {
                this.gridView.repaint();
            }
            return;
        }
        UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
        un.notifyInfo("Scale bar size", "A scale bar of the selected size cannot be displayed on the image. Please select a new size.");
        this.model.setUnitBarSize(oldUnit);
    }

    public boolean isUnitBar() {
        return this.model.isUnitBar();
    }

    public String getUnitBarValue() {
        return this.model.getUnitBarValue();
    }

    public double getUnitBarSize() {
        return this.model.getUnitBarSize();
    }

    public Color getUnitBarColor() {
        return this.model.getUnitBarColor();
    }

    public void setUnitBarColor(Color color) {
        if (this.model.getUnitBarColor().equals(color)) {
            return;
        }
        this.model.setUnitBarColor(color);
        this.view.repaint();
        if (this.model.getSelectedIndex() == 2) {
            this.gridView.repaint();
        }
    }

    public void scrollTo(Rectangle bounds, boolean blockIncrement) {
        if (bounds == null) {
            return;
        }
        this.view.scrollTo(bounds, blockIncrement);
    }

    public void setBackgroundColor(Color color) {
        if (this.model.getBackgroundColor().equals(color)) {
            return;
        }
        this.model.setBackgroundColor(color);
        this.view.getViewport().setBackground(color);
        if (this.model.getSelectedIndex() == 2) {
            this.gridView.getViewport().setBackground(color);
        }
    }

    public JComponent getAnnotator() {
        return this.annotator;
    }

    public Icon getAnnotatorIcon() {
        return this.model.getAnnotatorIcon();
    }

    public String getAnnotatorTitle() {
        return this.model.getAnnotatorTitle();
    }

    public JComponent getGridView() {
        return this.gridView;
    }

    public void setSelectedPane(int index) {
        switch (index) {
            case 1: {
                this.annotator.activateEditor();
                break;
            }
            case 2: {
                if (this.model.hasNoGridImages()) {
                    this.model.setGridImages();
                }
                this.gridView.paintImage();
            }
        }
    }

    public Icon getGridViewIcon() {
        return this.model.getGridViewIcon();
    }

    public String getGridViewTitle() {
        return this.model.getGridViewTitle();
    }

    public void viewSplitImages() {
        if (this.model.getSelectedIndex() != 2) {
            return;
        }
        this.model.setGridImages();
        this.gridView.paintImage();
    }

    public BufferedImage getGridImage() {
        return this.gridView.getGridImage();
    }

    public boolean hasAnnotationToSave() {
        return this.annotator.hasAnnotationToSave();
    }

    public void saveAnnotation() {
        this.annotator.saveAnnotation();
    }

    public BufferedImage getAnnotateImage() {
        return this.model.getAnnotateImage();
    }

    public void layoutAnnotator(JComponent left, JComponent right) {
        this.annotator.buildGUI(left, right);
    }

    public Point isOnImageInGrid(Rectangle rect) {
        return this.gridView.isOnImageInGrid(rect);
    }

    public double getRatio() {
        return this.model.getRatio();
    }
}

