/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JViewport;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.ImageCanvas;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;

class BrowserCanvas
extends ImageCanvas {
    private BrowserUI view;

    BrowserCanvas(BrowserModel model, BrowserUI view) {
        super(model);
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage img = this.model.getDisplayedImage();
        if (img == null) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        g2D.drawImage(img, null, 0, 0);
        if (!this.model.isUnitBar()) {
            return;
        }
        String value = this.model.getUnitBarValue();
        if (value == null) {
            return;
        }
        int size = (int)this.model.getUnitBarSize();
        Rectangle imgRect = new Rectangle(0, 0, img.getWidth(), img.getHeight());
        JViewport viewPort = this.view.getViewport();
        Rectangle viewRect = viewPort.getBounds();
        Point p = viewPort.getViewPosition();
        int x = (int)p.getX();
        int y = (int)p.getY();
        int width = Math.min(x + viewRect.width, img.getWidth());
        int height = Math.min(y + viewRect.height, img.getHeight());
        if (imgRect.contains(viewRect)) {
            width = x + viewRect.width;
            height = y + viewRect.height;
        }
        if (viewRect.width >= size) {
            ImagePaintingFactory.paintScaleBar(g2D, width - size - 10, height - 10, size, value, this.model.getUnitBarColor());
        }
    }
}

