/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.browser.AnnotatorCanvas;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.ImageCanvasListener;
import org.openmicroscopy.shoola.agents.imviewer.browser.InfoPane;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditor;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorFactory;
import pojos.DataObject;

class AnnotatorUI
extends JPanel {
    private AnnotatorCanvas canvas;
    private BrowserModel model;
    private BrowserControl controller;
    private AnnotatorEditor editor;
    private InfoPane infoPane;
    private JLayeredPane layeredPane;
    private JComponent left;
    private int leftWidth;
    private ImageCanvasListener canvasListener;

    private void initComponents() {
        this.layeredPane = new JLayeredPane();
        this.canvas = new AnnotatorCanvas(this.model);
        this.editor = AnnotatorFactory.getEditor(ImViewerAgent.getRegistry(), (DataObject)this.model.getImageData(), 0);
        this.infoPane = new InfoPane(this.model);
        this.canvasListener = new ImageCanvasListener(this.model, this.canvas);
        this.editor.addPropertyChangeListener(this.controller);
        this.layeredPane.add((Component)this.canvas, new Integer(0));
    }

    AnnotatorUI() {
    }

    void initialize(BrowserControl controller, BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
    }

    void paintImage() {
        if (this.model.getRenderedImage() == null) {
            return;
        }
        BufferedImage img = this.model.getAnnotateImage();
        int w = img.getWidth();
        int h = img.getHeight();
        this.canvasListener.setAreaSize(w, h);
        Dimension d = new Dimension(w, h);
        this.layeredPane.setPreferredSize(d);
        this.layeredPane.setSize(d);
        this.canvas.setPreferredSize(d);
        this.canvas.setSize(d);
        this.canvas.repaint();
        this.left.setPreferredSize(new Dimension(this.leftWidth, h));
    }

    void activateEditor() {
        if (this.editor != null && !this.editor.hasTextEntered()) {
            this.editor.activate();
        }
        if (this.infoPane != null) {
            this.infoPane.buildGUI();
        }
    }

    boolean hasAnnotationToSave() {
        if (this.editor == null) {
            return false;
        }
        return this.editor.hasTextEntered();
    }

    void saveAnnotation() {
        if (this.editor == null) {
            return;
        }
        this.editor.save();
    }

    void addComponentToLayer(JComponent c) {
        this.layeredPane.add((Component)c, new Integer(1));
    }

    void removeComponentFromLayer(JComponent c) {
        this.layeredPane.remove(c);
    }

    void buildGUI(JComponent left, JComponent bottom) {
        this.setLayout(new BorderLayout(0, 0));
        JPanel imagePanel = new JPanel();
        double[][] tl = new double[][]{{-2.0, -2.0, 5.0, -1.0}, {-2.0, -2.0, 5.0, -1.0}};
        imagePanel.setLayout((LayoutManager)new TableLayout((double[][])tl));
        this.left = left;
        this.leftWidth = left.getPreferredSize().width;
        left.setPreferredSize(this.layeredPane.getPreferredSize());
        imagePanel.add((Component)left, "0, 0");
        imagePanel.add((Component)this.layeredPane, "1, 0");
        imagePanel.add((Component)bottom, "1, 1");
        imagePanel.add((Component)new JSeparator(), "0, 3, 3, 3");
        this.add((Component)imagePanel, "North");
        this.add((Component)this.editor.getUI(), "Center");
    }
}

