/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;

class ZoomCmd {
    static final double INCREMENT = 0.25;
    static final int ZOOM_IN = 0;
    static final int ZOOM_OUT = 1;
    static final int ZOOM_FIT = 2;
    private int index;
    private ImViewer model;

    private void checkIndex(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not valid.");
    }

    ZoomCmd(ImViewer model, int index) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.checkIndex(index);
        this.model = model;
        this.index = index;
    }

    void execute() {
        double f = this.model.getZoomFactor();
        if (f < 0.0) {
            return;
        }
        double zoomFactor = 1.0;
        switch (this.index) {
            case 0: {
                if (f >= 3.0) {
                    zoomFactor = 3.0;
                    break;
                }
                zoomFactor = f + 0.25;
                break;
            }
            case 1: {
                if (f <= 0.25) {
                    zoomFactor = 0.25;
                    break;
                }
                zoomFactor = f - 0.25;
                break;
            }
            case 2: {
                zoomFactor = 1.0;
            }
        }
        this.model.setZoomFactor(zoomFactor, ZoomAction.getIndex(zoomFactor));
    }
}

