/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class RateImageAction
extends ViewerAction {
    public static final int RATE_ONE = 0;
    public static final int RATE_TWO = 1;
    public static final int RATE_THREE = 2;
    public static final int RATE_FOUR = 3;
    public static final int RATE_FIVE = 4;
    private static final int MAX = 4;
    private static final String DESCRIPTION = "Rate the image.";
    private static String[] names = new String[5];
    private int ratingIndex;

    private void controlsIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return;
            }
        }
        throw new IllegalArgumentException("Rating index not supported.");
    }

    public RateImageAction(ImViewer model, int ratingIndex) {
        super(model);
        this.setEnabled(true);
        this.controlsIndex(ratingIndex);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.ratingIndex = ratingIndex;
        this.putValue("Name", UIUtilities.formatToolTipText(names[ratingIndex]));
        this.name = names[ratingIndex];
    }

    public void actionPerformed(ActionEvent e) {
        this.model.setRateImage(this.ratingIndex);
    }

    static {
        RateImageAction.names[0] = "*";
        RateImageAction.names[1] = "**";
        RateImageAction.names[2] = "***";
        RateImageAction.names[3] = "****";
        RateImageAction.names[4] = "*****";
    }
}

