/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PlayMovieAction
extends ViewerAction {
    private static final String DESCRIPTION = "Play movie.";
    private IconManager icons = IconManager.getInstance();

    protected void onStateChange(ChangeEvent e) {
        switch (this.model.getState()) {
            case 7: {
                break;
            }
            case 8: {
                this.setEnabled(false);
                break;
            }
            case 6: 
            case 9: {
                this.setEnabled(this.model.getMaxT() != 0);
            }
        }
    }

    public PlayMovieAction(ImViewer model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("SmallIcon", this.icons.getIcon(IconManager.PLAY));
    }

    public void setActionIcon(boolean b) {
        if (b) {
            this.putValue("SmallIcon", this.icons.getIcon(IconManager.PLAY));
        } else {
            this.putValue("SmallIcon", this.icons.getIcon(IconManager.PAUSE));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.model.isMoviePlaying()) {
            this.setActionIcon(true);
            this.model.playMovie(false, false);
        } else {
            this.setActionIcon(false);
            this.model.playMovie(true, false);
        }
    }
}

