/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ColorPickerAction
extends ViewerAction
implements MouseListener {
    private static final String DESCRIPTION = "Bring up the color picker.";
    private Point point;

    public ColorPickerAction(ImViewer model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(IconManager.COLOR_PICKER));
    }

    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    public void mouseReleased(MouseEvent me) {
        Object source = me.getSource();
        if (source instanceof Component && this.isEnabled()) {
            this.model.showMenu(0, (Component)source, this.point);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

