/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ColorModelAction
extends ViewerAction {
    public static final String DESCRIPTION_RGB = "Colour model.";
    public static final String DESCRIPTION_GREY_SCALE = "Greyscale model.";
    public static final int GREY_SCALE_MODEL = 0;
    public static final int RGB_MODEL = 1;
    public static final int HSB_MODEL = 2;
    private static final int MAX = 2;
    private static String[] names = new String[3];
    private int modelIndex;

    private void controlIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Model not supported.");
    }

    private Icon getColorModelIcon(int index) {
        IconManager icons = IconManager.getInstance();
        switch (index) {
            default: {
                return icons.getIcon(IconManager.GRAYSCALE);
            }
            case 1: {
                return icons.getIcon(IconManager.RGB);
            }
            case 2: 
        }
        return icons.getIcon(IconManager.RGB);
    }

    private String getDescription(int index) {
        switch (index) {
            default: {
                return DESCRIPTION_GREY_SCALE;
            }
            case 1: 
            case 2: 
        }
        return DESCRIPTION_RGB;
    }

    public ColorModelAction(ImViewer model, int modelIndex) {
        super(model, "Name");
        this.controlIndex(modelIndex);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(this.getDescription(modelIndex)));
        this.modelIndex = modelIndex;
        this.putValue("Name", names[modelIndex]);
        this.putValue("SmallIcon", this.getColorModelIcon(modelIndex));
        this.name = names[modelIndex];
    }

    public int getIndex() {
        return this.modelIndex;
    }

    public void actionPerformed(ActionEvent e) {
        this.model.setColorModel(this.modelIndex);
    }

    static {
        ColorModelAction.names[0] = "Greyscale";
        ColorModelAction.names[1] = "Colour";
        ColorModelAction.names[2] = "HSB/HSV";
    }
}

