/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ChannelMovieAction
extends ViewerAction
implements PropertyChangeListener {
    private static final String DESCRIPTION = "Play movie across channels.";
    private IconManager icons = IconManager.getInstance();
    private boolean play;

    protected void onStateChange(ChangeEvent e) {
        if (this.play) {
            this.setEnabled(true);
        } else if (this.model.getState() == 6) {
            this.setEnabled(this.model.getActiveChannels().size() > 1);
        }
    }

    public ChannelMovieAction(ImViewer model) {
        super(model);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("SmallIcon", this.icons.getIcon(IconManager.PLAY));
        model.addPropertyChangeListener("channelActive", this);
    }

    public void actionPerformed(ActionEvent e) {
        Icon icon = (Icon)this.getValue("SmallIcon");
        this.play = false;
        if (icon.toString().equals(this.icons.getIcon(IconManager.PLAY).toString())) {
            this.putValue("SmallIcon", this.icons.getIcon(IconManager.PAUSE));
            this.play = true;
        } else {
            this.putValue("SmallIcon", this.icons.getIcon(IconManager.PLAY));
        }
        this.model.playChannelMovie(this.play);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("channelActive") && !this.play && this.model.getState() == 6) {
            this.setEnabled(this.model.getActiveChannels().size() > 1);
        }
    }
}

