/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import org.openmicroscopy.shoola.agents.events.iviewer.MeasurementTool;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.measurement.MeasurementToolLoaded;
import org.openmicroscopy.shoola.agents.events.measurement.SelectPlane;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;

public class ImViewerAgent
implements Agent,
AgentEventListener {
    public static final String ERROR = " An error occured while modifying  the rendering settings.";
    private static Registry registry;

    public static Registry getRegistry() {
        return registry;
    }

    private void handleViewImage(ViewImage evt) {
        if (evt == null) {
            return;
        }
        ImViewer view = ImViewerFactory.getImageViewer(evt.getPixelsID(), evt.getImageID(), evt.getName(), evt.getRequesterBounds());
        if (view != null) {
            view.activate();
        }
    }

    private void handleMeasurementToolLoaded(MeasurementToolLoaded evt) {
        if (evt == null) {
            return;
        }
        MeasurementTool request = (MeasurementTool)evt.getACT();
        long pixelsID = request.getPixelsID();
        ImViewer view = ImViewerFactory.getImageViewer(pixelsID);
        if (view != null) {
            switch (evt.getIndex()) {
                case 0: {
                    view.addView(evt.getView());
                    break;
                }
                case 1: {
                    view.removeView(evt.getView());
                }
            }
        }
    }

    private void handleSelectPlane(SelectPlane evt) {
        if (evt == null) {
            return;
        }
        long pixelsID = evt.getPixelsID();
        ImViewer view = ImViewerFactory.getImageViewer(pixelsID);
        if (view != null) {
            view.setSelectedXYPlane(evt.getDefaultZ(), evt.getDefaultT());
        }
    }

    public void activate() {
    }

    public void terminate() {
    }

    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, ViewImage.class);
        bus.register((AgentEventListener)this, MeasurementToolLoaded.class);
        bus.register((AgentEventListener)this, SelectPlane.class);
    }

    public boolean canTerminate() {
        return true;
    }

    public void eventFired(AgentEvent e) {
        if (e instanceof ViewImage) {
            this.handleViewImage((ViewImage)e);
        } else if (e instanceof MeasurementToolLoaded) {
            this.handleMeasurementToolLoaded((MeasurementToolLoaded)e);
        } else if (e instanceof SelectPlane) {
            this.handleSelectPlane((SelectPlane)e);
        }
    }
}

