/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;

public abstract class DataLoader
extends DSCallAdapter {
    protected final ImViewer viewer;
    protected final Registry registry;
    protected final ImageDataView ivView;

    protected DataLoader(ImViewer viewer) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.viewer = viewer;
        this.registry = ImViewerAgent.getRegistry();
        this.ivView = (ImageDataView)this.registry.getDataServicesView(ImageDataView.class);
    }

    public void onEnd() {
        this.viewer.setStatus(null, -1);
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        this.viewer.discard();
    }

    public abstract void load();

    public abstract void cancel();
}

