/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.AnnotateCmd;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ClassifyCmd;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.PropertiesCmd;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.ThumbWin;
import pojos.ImageData;

class ThumbWinPopupMenu
extends JPopupMenu {
    private static ThumbWinPopupMenu singleton = new ThumbWinPopupMenu();
    private ThumbWin currentWin;

    public static void showMenuFor(ThumbWin win) {
        if (win == null) {
            throw new NullPointerException("No window.");
        }
        ThumbWinPopupMenu.singleton.currentWin = win;
        singleton.showMenu();
    }

    public static void hideMenu() {
        singleton.setVisible(false);
    }

    private ThumbWinPopupMenu() {
        IconManager im = IconManager.getInstance();
        JMenuItem properties = new JMenuItem("Properties", im.getIcon(6));
        JMenuItem classify = new JMenuItem("Categorise", im.getIcon(25));
        JMenuItem declassify = new JMenuItem("Decategorise", im.getIcon(IconManager.DECATEGORISE));
        JMenuItem view = new JMenuItem("View", im.getIcon(7));
        JMenuItem annotate = new JMenuItem("Annotate", im.getIcon(8));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.add(view);
        this.add(new JSeparator(0));
        this.add(classify);
        this.add(declassify);
        this.add(annotate);
        this.add(new JSeparator(0));
        this.add(properties);
        properties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new PropertiesCmd(ThumbWinPopupMenu.this.currentWin.getModel(), ThumbWinPopupMenu.this.currentWin.getDataObject()).execute();
            }
        });
        annotate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new AnnotateCmd(ThumbWinPopupMenu.this.currentWin.getModel(), ThumbWinPopupMenu.this.currentWin.getSelectedNode()).execute();
            }
        });
        classify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ClassifyCmd cmd = new ClassifyCmd(ThumbWinPopupMenu.this.currentWin.getModel(), (ImageData)ThumbWinPopupMenu.this.currentWin.getDataObject(), 0);
                cmd.execute();
            }
        });
        declassify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ClassifyCmd cmd = new ClassifyCmd(ThumbWinPopupMenu.this.currentWin.getModel(), (ImageData)ThumbWinPopupMenu.this.currentWin.getDataObject(), 1);
                cmd.execute();
            }
        });
        view.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new ViewCmd(ThumbWinPopupMenu.this.currentWin.getDataObject()).execute();
            }
        });
    }

    private void showMenu() {
        Point p = this.currentWin.getPopupPoint();
        Point pNew = SwingUtilities.convertPoint(this.currentWin, p.x, p.y, null);
        this.show(this.currentWin.getParent(), pNew.x, pNew.y);
    }
}

