/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.hiviewer.util.RollOverWin;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.agents.hiviewer.view.ThumbWin;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;
import pojos.DataObject;
import pojos.ImageData;

class ThumbWinManager {
    private static final ThumbWinManager singleton = new ThumbWinManager();
    private static Map<Long, TinyDialog> windows;
    private static RollOverWin rollOverDialog;

    static void updateDisplayNodes(List nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        if (windows.size() == 0) {
            return;
        }
        for (Object node : nodes) {
            ImageData ho;
            ThumbWin w;
            if (!(node instanceof ImageData) || (w = (ThumbWin)windows.get(new Long((ho = (ImageData)node).getId()))) == null) continue;
            w.setDataObject((DataObject)ho);
        }
    }

    static void display(ImageNode node, HiViewer model) {
        singleton.displayNode(node, model);
    }

    static void rollOverDisplay(ImageNode node, Browser browser) {
        if (node == null) {
            if (rollOverDialog != null) {
                rollOverDialog.close();
                rollOverDialog = null;
            }
        } else {
            if (rollOverDialog == null) {
                rollOverDialog = new RollOverWin((JFrame)node.getTopLevelAncestor(), browser);
            }
            rollOverDialog.setImageNode(node);
            rollOverDialog.pack();
            Point p = singleton.getWindowLocation(node, rollOverDialog.getWidth(), rollOverDialog.getHeight());
            rollOverDialog.moveToFront(p);
            rollOverDialog.setVisible(true);
        }
    }

    private ThumbWinManager() {
        windows = new HashMap<Long, TinyDialog>();
        rollOverDialog = null;
    }

    private TinyDialog getWindowFor(ImageNode node, HiViewer model) {
        ImageData ho = (ImageData)node.getHierarchyObject();
        final Long id = new Long(ho.getId());
        TinyDialog w = windows.get(id);
        if (w == null) {
            Thumbnail prv = node.getThumbnail();
            BufferedImage full = prv.getFullScaleThumb();
            if (prv.getScalingFactor() == 1.0) {
                full = prv.getZoomedFullScaleThumb();
            }
            if (full != null) {
                w = new ThumbWin((JFrame)node.getTopLevelAncestor(), full, (DataObject)ho, model, node);
                w.moveToFront();
                w.addPropertyChangeListener("closed", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent pce) {
                        windows.remove(id);
                    }
                });
                windows.put(id, w);
                w.setTitle(node.getTitle());
            }
        }
        return w;
    }

    private Point getWindowLocation(ImageNode node, int winW, int winH) {
        Rectangle r = node.getBounds();
        int offsetX = Math.abs(winW - r.width) / 2;
        int offsetY = Math.abs(winH - r.height) / 2;
        Point p = node.getLocationOnScreen();
        p.x -= offsetX;
        p.y -= offsetY;
        return p;
    }

    private void displayNode(ImageNode node, HiViewer model) {
        if (node == null) {
            throw new IllegalArgumentException("No node.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        TinyDialog w = this.getWindowFor(node, model);
        if (w != null) {
            w.pack();
            Point p = this.getWindowLocation(node, w.getWidth(), w.getHeight());
            w.setCollapsed(false);
            w.moveToFront(p);
        }
    }
}

