/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.hiviewer.browser.AnnotatedButton;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ClassifiedButton;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.agents.hiviewer.view.ThumbWinPopupMenu;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;
import pojos.DataObject;
import pojos.ImageData;

class ThumbWin
extends TinyDialog
implements MouseListener,
PropertyChangeListener {
    private ImageDisplay node;
    private DataObject dataObject;
    private Point popupPoint;
    private JFrame parentFrame;
    private HiViewer model;

    private void onClick(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.popupPoint = me.getPoint();
            ThumbWinPopupMenu.showMenuFor(this);
        }
    }

    private boolean isAnnotated() {
        if (this.dataObject instanceof ImageData) {
            ImageData d = (ImageData)this.dataObject;
            Long n = d.getAnnotationCount();
            return n != null && n > 0L;
        }
        return false;
    }

    private boolean isClassified() {
        if (this.dataObject instanceof ImageData) {
            ImageData d = (ImageData)this.dataObject;
            Long n = d.getClassificationCount();
            return n != null && n > 0L;
        }
        return false;
    }

    private void setNodeDecoration() {
        if (!(this.node instanceof ImageNode)) {
            return;
        }
        ArrayList<JButton> nodes = new ArrayList<JButton>();
        if (this.isAnnotated()) {
            nodes.add(new AnnotatedButton((ImageNode)this.node, false));
        }
        if (this.isClassified()) {
            nodes.add(new ClassifiedButton((ImageNode)this.node, false));
        }
        this.setDecoration(nodes);
    }

    ThumbWin(JFrame parent, BufferedImage fullScaleThumb, DataObject image, HiViewer model, ImageDisplay node) {
        super((Frame)parent, fullScaleThumb);
        if (image == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (node == null) {
            throw new IllegalArgumentException("No node.");
        }
        this.dataObject = image;
        this.parentFrame = parent;
        this.model = model;
        this.node = node;
        this.uiDelegate.attachMouseListener(this);
        this.addMouseListener(this);
        this.addPropertyChangeListener("closed", this);
        this.setNodeDecoration();
    }

    void setDataObject(DataObject image) {
        if (image == null) {
            throw new IllegalArgumentException("No image.");
        }
        this.dataObject = image;
        this.setNodeDecoration();
        this.validate();
        this.repaint();
    }

    HiViewer getModel() {
        return this.model;
    }

    DataObject getDataObject() {
        return this.dataObject;
    }

    ImageDisplay getSelectedNode() {
        return this.node;
    }

    Point getPopupPoint() {
        return this.popupPoint;
    }

    JFrame getParentFrame() {
        return this.parentFrame;
    }

    long getUserID() {
        return this.model.getUserDetails().getId();
    }

    public void mouseReleased(MouseEvent me) {
        this.onClick(me);
        if (me.getClickCount() == 2) {
            ViewCmd cmd = new ViewCmd((DataObject)((ImageData)this.node.getHierarchyObject()));
            cmd.execute();
        }
    }

    public void mousePressed(MouseEvent me) {
        ThumbWinPopupMenu.hideMenu();
        this.onClick(me);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        ThumbWinPopupMenu.hideMenu();
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }
}

