/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.DataLoader;
import org.openmicroscopy.shoola.agents.hiviewer.ProjectLoader;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectModel
extends HiViewerModel {
    private Set<Long> projectsID;

    ProjectModel(long projectID) {
        this.projectsID = new HashSet<Long>(1);
        this.projectsID.add(new Long(projectID));
    }

    ProjectModel(Set<Long> projectsID) {
        this.projectsID = projectsID;
    }

    @Override
    protected int getHierarchyType() {
        return 101;
    }

    @Override
    protected boolean isSameDisplay(HiViewerModel other) {
        if (other == null || !(other instanceof ProjectModel)) {
            return false;
        }
        ProjectModel pm = (ProjectModel)other;
        if (pm.getHierarchyType() != this.getHierarchyType()) {
            return false;
        }
        if (pm.projectsID.size() != this.projectsID.size()) {
            return false;
        }
        Iterator<Long> i = pm.projectsID.iterator();
        int index = this.projectsID.size();
        while (i.hasNext()) {
            Long id = i.next();
            Iterator<Long> j = this.projectsID.iterator();
            while (j.hasNext()) {
                if (id.longValue() != j.next().longValue()) continue;
                --index;
            }
        }
        return index == 0;
    }

    @Override
    protected DataLoader createHierarchyLoader(boolean refresh) {
        return new ProjectLoader(this.component, this.projectsID, refresh);
    }

    @Override
    protected HiViewerModel reinstantiate() {
        ProjectModel model = new ProjectModel(this.projectsID);
        model.setRootLevel(this.getExperimenter(), this.getUserGroupID());
        return model;
    }
}

