/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.CGCILoader;
import org.openmicroscopy.shoola.agents.hiviewer.DataLoader;
import org.openmicroscopy.shoola.agents.hiviewer.PDILoader;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerModel;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HierarchyModel
extends HiViewerModel {
    private Set<ImageData> images;
    private int type;

    private void checkType(int v) {
        switch (v) {
            case 105: 
            case 106: {
                return;
            }
        }
        throw new IllegalArgumentException("Hierarchy not supported");
    }

    HierarchyModel(Set<ImageData> images, int type) {
        if (images == null) {
            throw new NullPointerException("No images.");
        }
        this.checkType(type);
        this.images = images;
        this.type = type;
    }

    @Override
    protected int getHierarchyType() {
        return this.type;
    }

    @Override
    protected boolean isSameDisplay(HiViewerModel other) {
        ImageData data;
        if (other == null || !(other instanceof HierarchyModel) || other.getHierarchyType() != this.getHierarchyType()) {
            return false;
        }
        HierarchyModel hm = (HierarchyModel)other;
        if (this.images.size() != hm.images.size()) {
            return false;
        }
        HashMap<Long, ImageData> myImgs = new HashMap<Long, ImageData>();
        HashMap<Long, ImageData> otherImgs = new HashMap<Long, ImageData>();
        Iterator<Object> i = this.images.iterator();
        Iterator<ImageData> j = hm.images.iterator();
        while (i.hasNext()) {
            data = i.next();
            myImgs.put(new Long(data.getId()), data);
        }
        while (j.hasNext()) {
            data = j.next();
            otherImgs.put(new Long(data.getId()), data);
        }
        i = myImgs.keySet().iterator();
        while (i.hasNext()) {
            if (otherImgs.get(i.next()) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected DataLoader createHierarchyLoader(boolean refresh) {
        HashSet<Long> ids = new HashSet<Long>(this.images.size());
        Iterator<ImageData> i = this.images.iterator();
        while (i.hasNext()) {
            ids.add(new Long(i.next().getId()));
        }
        switch (this.type) {
            case 105: {
                return new PDILoader(this.component, ids, refresh);
            }
            case 106: {
                return new CGCILoader(this.component, ids, refresh);
            }
        }
        return null;
    }

    @Override
    protected HiViewerModel reinstantiate() {
        HashSet<ImageData> copy = new HashSet<ImageData>(this.images);
        return new HierarchyModel(copy, this.type);
    }
}

