/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.actions.HiViewerAction;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.layout.LayoutFactory;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerControl;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerModel;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerToolBar;
import org.openmicroscopy.shoola.agents.hiviewer.view.PopupMenu;
import org.openmicroscopy.shoola.agents.hiviewer.view.StatusBar;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.util.DataHandler;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class HiViewerWin
extends TopWindow {
    public static final Color BACKGROUND = new Color(250, 253, 255);
    private static final int TITLE_MAX_LENGTH = 50;
    private static final String DEFAULT_TITLE = "Hierarchy Viewer";
    private StatusBar statusBar;
    private PopupMenu popupMenu;
    private HiViewerToolBar toolBar;
    private JSplitPane mainPane;
    private HiViewerControl controller;
    private HiViewerModel model;
    private int lastMove;

    private void lastMove() {
        if (this.lastMove != -1) {
            this.mainPane.setDividerLocation(this.lastMove);
            this.mainPane.setResizeWeight(0.0);
        }
    }

    private JSplitPane createSplitPane(JComponent browserUI, JComponent clipBoardUI) {
        int orientation = 1;
        orientation = 0;
        this.mainPane = new JSplitPane(orientation, browserUI, clipBoardUI);
        this.mainPane.setOneTouchExpandable(true);
        this.mainPane.setContinuousLayout(true);
        this.mainPane.setResizeWeight(1.0);
        this.lastMove();
        return this.mainPane;
    }

    private void buildUI() {
        JPanel p = new JPanel();
        p.setBackground(BACKGROUND);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        this.addToContainer(p);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createViewMenu());
        TaskBar tb = HiViewerAgent.getRegistry().getTaskBar();
        menuBar.add(tb.getWindowsMenu());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }

    private JMenu createLayoutMenu() {
        IconManager im = IconManager.getInstance();
        JMenu menu = new JMenu("Layout");
        menu.setIcon(im.getIcon(39));
        int index = LayoutFactory.getDefaultLayoutIndex();
        ButtonGroup group = new ButtonGroup();
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        item.setSelected(index == 1);
        item.setAction(this.controller.getAction(HiViewerControl.SQUARY));
        group.add(item);
        menu.add(item);
        item = new JCheckBoxMenuItem();
        item.setSelected(index == 2);
        item.setAction(this.controller.getAction(HiViewerControl.FLAT_LAYOUT));
        group.add(item);
        menu.add(item);
        return menu;
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menu.add(new JMenuItem(this.controller.getAction(HiViewerControl.SAVE_THUMB)));
        menu.add(new JSeparator(0));
        HiViewerAction a = (HiViewerAction)this.controller.getAction(HiViewerControl.REFRESH);
        JMenuItem item = new JMenuItem(a);
        item.setText(a.getName());
        menu.add(item);
        menu.add(new JSeparator(0));
        menu.add(new JMenuItem(this.controller.getAction(HiViewerControl.EXIT)));
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menu.add(new JMenuItem(this.controller.getAction(HiViewerControl.FIND)));
        menu.add(new JSeparator(0));
        menu.add(new JMenuItem(this.controller.getAction(HiViewerControl.VIEW)));
        menu.add(new JSeparator(0));
        menu.add(new JMenuItem(this.controller.getAction(HiViewerControl.CLASSIFY)));
        menu.add(new JMenuItem(this.controller.getAction(HiViewerControl.DECLASSIFY)));
        menu.add(new JMenuItem(this.controller.getAction(HiViewerControl.ANNOTATE)));
        menu.add(new JMenuItem(this.controller.getAction(HiViewerControl.REMOVE)));
        menu.add(new JSeparator(0));
        menu.add(new JMenuItem(this.controller.getAction(HiViewerControl.PROPERTIES)));
        return menu;
    }

    private JMenu createViewMenu() {
        JMenu menu = new JMenu("View");
        menu.setMnemonic(86);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        item.setSelected(false);
        item.setText("Show Tree Pane");
        item.setAction(this.controller.getAction(HiViewerControl.TREE_VIEW));
        item = new JCheckBoxMenuItem();
        item.setSelected(true);
        item.setAction(this.controller.getAction(HiViewerControl.CLIPBOARD_VIEW));
        item.setText("Show Working Area");
        item = new JCheckBoxMenuItem();
        item.setSelected(this.model.isTitleBarVisible());
        item.setAction(this.controller.getAction(HiViewerControl.SHOW_TITLEBAR));
        menu.add(item);
        menu.add(new JSeparator(0));
        JMenuItem mi = new JMenuItem(this.controller.getAction(HiViewerControl.ZOOM_IN));
        mi.setText("Zoom in");
        menu.add(mi);
        mi = new JMenuItem(this.controller.getAction(HiViewerControl.ZOOM_OUT));
        mi.setText("Zoom out");
        menu.add(mi);
        mi = new JMenuItem(this.controller.getAction(HiViewerControl.ZOOM_FIT));
        mi.setText("Normal Size");
        menu.add(mi);
        menu.add(new JSeparator(0));
        menu.add(this.createLayoutMenu());
        menu.add(new JMenuItem(this.controller.getAction(HiViewerControl.RESET_LAYOUT)));
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenu file = new JMenu("Help");
        TaskBar bar = TreeViewerAgent.getRegistry().getTaskBar();
        JMenuItem item = bar.getCopyMenuItem(100);
        if (item != null) {
            file.add(item);
        }
        return file;
    }

    private void addToContainer(JComponent body) {
        Container container = this.getContentPane();
        container.add((Component)this.toolBar, "North");
        container.add((Component)body, "Center");
        container.add((Component)this.statusBar, "South");
    }

    HiViewerWin() {
        super(DEFAULT_TITLE);
        IconManager iconMng = IconManager.getInstance();
        this.statusBar = new StatusBar(iconMng.getIcon(IconManager.INFO));
        this.lastMove = -1;
    }

    void initialize(HiViewerControl controller, HiViewerModel model) {
        this.controller = controller;
        this.model = model;
        this.popupMenu = new PopupMenu(controller);
        this.toolBar = new HiViewerToolBar(controller, model);
        this.setJMenuBar(this.createMenuBar());
        this.buildUI();
    }

    void setViews(JComponent browserView, JComponent clipBoardView) {
        Container container = this.getContentPane();
        container.removeAll();
        this.addToContainer(this.createSplitPane(browserView, clipBoardView));
    }

    void setStatus(String status, boolean hideProgressBar, int progressPerc) {
        this.statusBar.setStatus(status);
        this.statusBar.setProgress(hideProgressBar, progressPerc);
    }

    void showPopup(Component c, Point p) {
        this.popupMenu.show(c, p.x, p.y);
    }

    void closeViewer() {
        this.setVisible(false);
        this.dispose();
    }

    void setViewTitle() {
        String title = "Hierarchy Viewer: ";
        title = title + this.getViewTitle();
        this.setTitle(title);
    }

    void showClipBoard(boolean b) {
        JComponent cb = this.model.getClipBoard().getUI();
        if (cb == null) {
            return;
        }
        if (b) {
            this.mainPane.setRightComponent(cb);
            this.lastMove();
        } else {
            this.lastMove = this.mainPane.getDividerLocation();
            this.mainPane.remove(cb);
        }
        ((BasicSplitPaneUI)this.mainPane.getUI()).getDivider().setVisible(b);
    }

    void showTreeView(boolean b) {
        Container container = this.getContentPane();
        if (b) {
            JSplitPane treeViewPane = new JSplitPane();
            treeViewPane.setOrientation(1);
            treeViewPane.setOneTouchExpandable(true);
            treeViewPane.setContinuousLayout(true);
            if (this.model.getTreeView() == null) {
                this.model.createTreeView();
            }
            treeViewPane.setLeftComponent(this.model.getTreeView());
            treeViewPane.setRightComponent(this.mainPane);
            container.remove(this.mainPane);
            container.add((Component)treeViewPane, "Center");
        } else {
            container.removeAll();
            this.addToContainer(this.mainPane);
        }
        container.validate();
        container.repaint();
    }

    String getViewTitle() {
        Set roots = this.model.getBrowser().getRootNodes();
        Iterator i = roots.iterator();
        StringBuffer buf = new StringBuffer();
        String title = "";
        while (i.hasNext()) {
            if ((title = title + ((ImageDisplay)i.next()).getTitle()).length() <= 50) continue;
            title.substring(0, 47);
            title = title + "...";
            break;
        }
        buf.insert(0, title);
        return buf.toString();
    }

    DataHandler getDataHandler() {
        return this.model.getDataHandler();
    }

    void discardDataHandler() {
        this.model.discardDataHandler();
    }

    void setComponentBounds(Rectangle bounds) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 8 * (screenSize.width / 10);
        int height = 8 * (screenSize.height / 10);
        this.setSize(width, height);
        UIUtilities.incrementRelativeToAndShow(bounds, this);
    }

    public void setOnScreen() {
        this.setComponentBounds(null);
    }
}

