/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerControl;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class HiViewerToolBar
extends JPanel {
    private static final Dimension HBOX = new Dimension(100, 16);
    private static final Dimension HGLUE = new Dimension(5, 5);
    private HiViewerControl controller;
    private HiViewerModel model;

    private JToolBar buildGeneralBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(new JButton(this.controller.getAction(HiViewerControl.REFRESH)));
        bar.add(Box.createRigidArea(HGLUE));
        bar.add(new JSeparator(1));
        bar.add(Box.createRigidArea(HGLUE));
        return bar;
    }

    private JToolBar buildViewBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        JToggleButton b = new JToggleButton(this.controller.getAction(HiViewerControl.TREE_VIEW));
        bar.add(b);
        b = new JToggleButton(this.controller.getAction(HiViewerControl.CLIPBOARD_VIEW));
        b.setSelected(true);
        bar.add(b);
        bar.add(Box.createRigidArea(HGLUE));
        bar.add(new JSeparator(1));
        bar.add(Box.createRigidArea(HGLUE));
        return bar;
    }

    private JToolBar buildManagementBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        ButtonGroup group = new ButtonGroup();
        JToggleButton b = new JToggleButton();
        b.setSelected(true);
        group.add(b);
        b.setAction(this.controller.getAction(HiViewerControl.SORT_BY_NAME));
        bar.add(b);
        b = new JToggleButton(this.controller.getAction(HiViewerControl.SORT_BY_DATE));
        group.add(b);
        bar.add(b);
        bar.add(Box.createRigidArea(HGLUE));
        bar.add(new JSeparator(1));
        bar.add(Box.createRigidArea(HGLUE));
        b = new JToggleButton(this.controller.getAction(HiViewerControl.MOUSE_OVER));
        b.setSelected(this.model.isMouseOver());
        bar.add(b);
        b = new JToggleButton(this.controller.getAction(HiViewerControl.ROLL_OVER));
        b.setSelected(this.model.isRollOver());
        bar.add(b);
        bar.add(Box.createRigidArea(HGLUE));
        JButton button = new JButton(this.controller.getAction(HiViewerControl.ZOOM_IN));
        UIUtilities.unifiedButtonLookAndFeel(button);
        bar.add(button);
        button = new JButton(this.controller.getAction(HiViewerControl.ZOOM_OUT));
        UIUtilities.unifiedButtonLookAndFeel(button);
        bar.add(button);
        button = new JButton(this.controller.getAction(HiViewerControl.ZOOM_FIT));
        UIUtilities.unifiedButtonLookAndFeel(button);
        bar.add(button);
        return bar;
    }

    private void buildGUI() {
        JPanel bars = new JPanel();
        JPanel outerPanel = new JPanel();
        bars.setBorder(null);
        bars.setLayout(new BoxLayout(bars, 0));
        bars.add(this.buildGeneralBar());
        bars.add(this.buildViewBar());
        bars.add(this.buildManagementBar());
        outerPanel.setBorder(null);
        outerPanel.setLayout(new BoxLayout(outerPanel, 0));
        outerPanel.add(bars);
        outerPanel.add(Box.createRigidArea(HBOX));
        outerPanel.add(Box.createHorizontalGlue());
        this.setLayout(new FlowLayout(0));
        this.add(outerPanel);
    }

    HiViewerToolBar(HiViewerControl controller, HiViewerModel model) {
        if (controller == null) {
            throw new NullPointerException("No controller.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.buildGUI();
    }
}

