/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.hiviewer.DataLoader;
import org.openmicroscopy.shoola.agents.hiviewer.DataObjectRemover;
import org.openmicroscopy.shoola.agents.hiviewer.DataObjectSaver;
import org.openmicroscopy.shoola.agents.hiviewer.HiTranslator;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.hiviewer.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.hiviewer.ThumbnailsManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoard;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoardFactory;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.IconsVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.layout.Layout;
import org.openmicroscopy.shoola.agents.hiviewer.layout.LayoutFactory;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeView;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.agents.util.DataHandler;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorFactory;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierFactory;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.ProjectData;

abstract class HiViewerModel {
    private ExperimenterData experimenter;
    private long userGroupID;
    private int state = 1;
    private Browser browser;
    private ClipBoard clipBoard;
    private TreeView treeView;
    private DataLoader currentLoader;
    private ThumbnailsManager thumbsManager;
    private ViewerSorter sorter = new ViewerSorter();
    private DataHandler dataHandler;
    protected HiViewer component;

    private void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
        }
    }

    protected HiViewerModel() {
    }

    void initialize(HiViewer component) {
        this.component = component;
    }

    void setUserDetails(ExperimenterData details) {
        HiViewerAgent.getRegistry().bind("/current_user/details", details);
    }

    void setRootLevel(ExperimenterData experimenter, long userGroupID) {
        this.experimenter = experimenter;
        this.userGroupID = userGroupID;
    }

    long getRootID() {
        return this.experimenter.getId();
    }

    long getUserGroupID() {
        return this.userGroupID;
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)HiViewerAgent.getRegistry().lookup("/current_user/details");
    }

    ExperimenterData getExperimenter() {
        return this.experimenter;
    }

    int getState() {
        return this.state;
    }

    void fireHierarchyLoading(boolean refresh) {
        this.cancel();
        this.state = 2;
        this.currentLoader = this.createHierarchyLoader(refresh);
        this.currentLoader.load();
    }

    void refreshBrowser(Set roots, boolean flat) {
        this.thumbsManager = null;
        long userID = this.getUserDetails().getId();
        Set visTrees = flat ? HiTranslator.transformImages(roots, userID, this.userGroupID) : HiTranslator.transformHierarchy(roots, userID, this.userGroupID);
        int layoutIndex = this.browser.getSelectedLayout();
        Layout layout = LayoutFactory.createLayout(layoutIndex, this.sorter);
        switch (layoutIndex) {
            case 2: {
                layout.setOldNodes(this.browser.getImageNodes());
                break;
            }
            default: {
                HashSet<JComponent> set = new HashSet<JComponent>();
                Set oldNodes = this.browser.getRootNodes();
                if (oldNodes != null) {
                    for (ImageDisplay n : oldNodes) {
                        set.add(n);
                        if (n.containsImages()) continue;
                        set.addAll(n.getChildrenDisplay());
                    }
                }
                set.add(this.browser.getUI());
                layout.setOldNodes(set);
            }
        }
        this.browser = BrowserFactory.createBrowser(visTrees);
        this.browser.setSelectedLayout(layoutIndex);
        switch (layoutIndex) {
            case 2: {
                this.browser.resetChildDisplay();
                this.browser.accept(layout);
                layout.doLayout();
                break;
            }
            default: {
                this.browser.accept(layout, 1);
            }
        }
        this.browser.accept(new IconsVisitor(), 1);
    }

    void createBrowser(Set roots, boolean flat) {
        if (roots == null) {
            throw new NullPointerException("No roots.");
        }
        long userID = this.getUserDetails().getId();
        Set visTrees = flat ? HiTranslator.transformImages(roots, userID, this.userGroupID) : HiTranslator.transformHierarchy(roots, userID, this.userGroupID);
        this.browser = BrowserFactory.createBrowser(visTrees);
        Layout layout = LayoutFactory.getDefaultLayout(this.sorter);
        this.browser.setSelectedLayout(layout.getIndex());
        this.browser.accept(layout, 1);
        this.browser.accept(new IconsVisitor(), 1);
    }

    void createClipBoard() {
        this.clipBoard = ClipBoardFactory.createClipBoard(this.component);
    }

    Browser getBrowser() {
        return this.browser;
    }

    ClipBoard getClipBoard() {
        return this.clipBoard;
    }

    TreeView getTreeView() {
        return this.treeView;
    }

    void createTreeView() {
        if (this.treeView == null) {
            this.treeView = new TreeView((ImageDisplay)this.browser.getUI());
        }
    }

    void fireThumbnailLoading() {
        Set<ImageData> images = this.browser.getImages();
        if (images.size() == 0) {
            this.state = 5;
            return;
        }
        this.state = 3;
        this.currentLoader = new ThumbnailLoader(this.component, images);
        this.currentLoader.load();
    }

    void fireDataObjectUpdate(DataObject object) {
        this.state = 4;
        this.currentLoader = new DataObjectSaver(this.component, object);
        this.currentLoader.load();
    }

    void fireDataObjectsRemoval(List nodes) {
        this.state = 4;
        Iterator i = nodes.iterator();
        HashSet<DataObject> toRemove = null;
        HashMap<DataObject, HashSet<DataObject>> map = null;
        while (i.hasNext()) {
            HashSet<DataObject> l;
            ImageDisplay node = (ImageDisplay)i.next();
            ImageDisplay parent = node.getParentDisplay();
            Object ho = node.getHierarchyObject();
            if (!(ho instanceof DataObject)) continue;
            DataObject object = (DataObject)ho;
            if (object instanceof ProjectData || object instanceof CategoryGroupData) {
                if (toRemove == null) {
                    toRemove = new HashSet<DataObject>();
                }
                toRemove.add(object);
                continue;
            }
            DataObject po = (DataObject)parent.getHierarchyObject();
            if (map == null) {
                map = new HashMap<DataObject, HashSet<DataObject>>();
            }
            if ((l = (HashSet<DataObject>)map.get(po)) == null) {
                l = new HashSet<DataObject>();
            }
            l.add(object);
            map.put(po, l);
        }
        if (toRemove != null) {
            this.currentLoader = new DataObjectRemover(this.component, toRemove, null);
            this.currentLoader.load();
        } else {
            this.currentLoader = new DataObjectRemover(this.component, map);
            this.currentLoader.load();
        }
    }

    void setThumbnail(long imageID, BufferedImage thumb) {
        if (this.thumbsManager == null) {
            this.thumbsManager = new ThumbnailsManager(this.browser.getImageNodes());
        }
        this.thumbsManager.setThumbnail(imageID, thumb);
        if (this.thumbsManager.isDone()) {
            this.state = 5;
            this.thumbsManager = null;
        }
    }

    void discard() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 6;
    }

    void setRollOver(boolean rollOver) {
        if (this.browser != null) {
            this.browser.setRollOver(rollOver);
        }
    }

    boolean isRollOver() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.isRollOver();
    }

    boolean isTitleBarVisible() {
        if (this.browser == null) {
            return true;
        }
        return this.browser.isTitleBarVisible();
    }

    ViewerSorter getSorter() {
        return this.sorter;
    }

    DataHandler annotateDataObjects(JFrame owner, Set nodes) {
        HashSet<Object> toAnnotate = new HashSet<Object>();
        Iterator i = nodes.iterator();
        Class<ImageData> type = null;
        while (i.hasNext()) {
            Object uo = ((ImageDisplay)i.next()).getHierarchyObject();
            if (uo instanceof ImageData) {
                type = ImageData.class;
                toAnnotate.add(uo);
                continue;
            }
            if (!(uo instanceof DatasetData)) continue;
            type = DatasetData.class;
            toAnnotate.add(uo);
        }
        this.dataHandler = AnnotatorFactory.getAnnotator(owner, toAnnotate, HiViewerAgent.getRegistry(), type);
        return this.dataHandler;
    }

    DataHandler classifyImageObjects(JFrame owner, ImageData[] nodes, int mode) {
        HashSet<ImageData> images = new HashSet<ImageData>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            images.add(nodes[i]);
        }
        this.dataHandler = ClassifierFactory.getClassifier(owner, images, this.getRootID(), mode, HiViewerAgent.getRegistry());
        return this.dataHandler;
    }

    DataHandler annotateChildren(JFrame owner, ImageDisplay node) {
        Object uo = node.getHierarchyObject();
        HashSet<Object> toAnnotate = new HashSet<Object>();
        if (uo instanceof DatasetData) {
            toAnnotate.add(uo);
            this.dataHandler = AnnotatorFactory.getChildrenAnnotator(owner, toAnnotate, HiViewerAgent.getRegistry(), DatasetData.class);
            return this.dataHandler;
        }
        if (uo instanceof CategoryData) {
            toAnnotate.add(uo);
            this.dataHandler = AnnotatorFactory.getChildrenAnnotator(owner, toAnnotate, HiViewerAgent.getRegistry(), CategoryData.class);
            return this.dataHandler;
        }
        return null;
    }

    DataHandler classifyChildren(JFrame owner, ImageDisplay node) {
        Object uo = node.getHierarchyObject();
        if (uo instanceof DatasetData || uo instanceof CategoryData) {
            HashSet<DataObject> folders = new HashSet<DataObject>(1);
            folders.add((DataObject)uo);
            this.dataHandler = ClassifierFactory.getChildrenClassifier(owner, folders, this.getRootID(), HiViewerAgent.getRegistry());
            return this.dataHandler;
        }
        return null;
    }

    void discardDataHandler() {
        if (this.dataHandler != null) {
            this.dataHandler.discard();
            this.dataHandler = null;
        }
    }

    boolean isMouseOver() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.isMouseOver();
    }

    void setMouseOver(boolean b) {
        if (this.browser != null) {
            this.browser.setMouseOver(b);
        }
    }

    void onDataObjectSave() {
        this.state = 5;
    }

    DataHandler getDataHandler() {
        return this.dataHandler;
    }

    protected abstract int getHierarchyType();

    protected abstract boolean isSameDisplay(HiViewerModel var1);

    protected abstract DataLoader createHierarchyLoader(boolean var1);

    protected abstract HiViewerModel reinstantiate();
}

