/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.hiviewer.view.CategoryGroupModel;
import org.openmicroscopy.shoola.agents.hiviewer.view.CategoryModel;
import org.openmicroscopy.shoola.agents.hiviewer.view.DatasetModel;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerComponent;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerModel;
import org.openmicroscopy.shoola.agents.hiviewer.view.HierarchyModel;
import org.openmicroscopy.shoola.agents.hiviewer.view.ImagesModel;
import org.openmicroscopy.shoola.agents.hiviewer.view.ProjectModel;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import pojos.ExperimenterData;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiViewerFactory
implements ChangeListener {
    private static final HiViewerFactory singleton = new HiViewerFactory();
    private Set<HiViewer> viewers = new HashSet<HiViewer>();
    private JMenu windowMenu = new JMenu("HiViewers");
    private boolean isAttached = false;

    static Set getViewers() {
        return HiViewerFactory.singleton.viewers;
    }

    static JMenu getWindowMenu() {
        return HiViewerFactory.singleton.windowMenu;
    }

    static boolean isWindowMenuAttachedToTaskBar() {
        return HiViewerFactory.singleton.isAttached;
    }

    static void attachWindowMenuToTaskBar() {
        if (HiViewerFactory.isWindowMenuAttachedToTaskBar()) {
            return;
        }
        TaskBar tb = HiViewerAgent.getRegistry().getTaskBar();
        tb.addToMenu(0, HiViewerFactory.singleton.windowMenu);
        HiViewerFactory.singleton.isAttached = true;
    }

    public static HiViewer getImagesViewer(Set ids, ExperimenterData exp, long userGroupID) {
        ImagesModel model = new ImagesModel(ids);
        model.setRootLevel(exp, userGroupID);
        return singleton.getViewer(model);
    }

    public static HiViewer getDatasetsViewer(Set<Long> ids, ExperimenterData exp, long userGroupID) {
        DatasetModel model = new DatasetModel(ids);
        model.setRootLevel(exp, userGroupID);
        return singleton.getViewer(model);
    }

    public static HiViewer getCategoriesViewer(Set<Long> ids, ExperimenterData exp, long userGroupID) {
        CategoryModel model = new CategoryModel(ids);
        model.setRootLevel(exp, userGroupID);
        return singleton.getViewer(model);
    }

    public static HiViewer getProjectsViewer(Set<Long> ids, ExperimenterData exp, long userGroupID) {
        ProjectModel model = new ProjectModel(ids);
        model.setRootLevel(exp, userGroupID);
        return singleton.getViewer(model);
    }

    public static HiViewer getCategoryGroupsViewer(Set<Long> ids, ExperimenterData exp, long userGroupID) {
        CategoryGroupModel model = new CategoryGroupModel(ids);
        model.setRootLevel(exp, userGroupID);
        return singleton.getViewer(model);
    }

    public static HiViewer getProjectViewer(long projectID, ExperimenterData exp, long userGroupID) {
        ProjectModel model = new ProjectModel(projectID);
        model.setRootLevel(exp, userGroupID);
        return singleton.getViewer(model);
    }

    public static HiViewer getDatasetViewer(long datasetID, ExperimenterData exp, long userGroupID) {
        DatasetModel model = new DatasetModel(datasetID);
        model.setRootLevel(exp, userGroupID);
        return singleton.getViewer(model);
    }

    public static HiViewer getCategoryGroupViewer(long cgID, ExperimenterData exp, long userGroupID) {
        CategoryGroupModel model = new CategoryGroupModel(cgID);
        model.setRootLevel(exp, userGroupID);
        return singleton.getViewer(model);
    }

    public static HiViewer getCategoryViewer(long categoryID, ExperimenterData exp, long userGroupID) {
        CategoryModel model = new CategoryModel(categoryID);
        model.setRootLevel(exp, userGroupID);
        return singleton.getViewer(model);
    }

    public static HiViewer getPDIViewer(Set<ImageData> images, ExperimenterData exp, long userGroupID) {
        HierarchyModel model = new HierarchyModel(images, 105);
        model.setRootLevel(exp, userGroupID);
        return singleton.getViewer(model);
    }

    public static HiViewer getCGCIViewer(Set<ImageData> images, ExperimenterData exp, long userGroupID) {
        HierarchyModel model = new HierarchyModel(images, 106);
        model.setRootLevel(exp, userGroupID);
        return singleton.getViewer(model);
    }

    public static HiViewer reinstantiate(HiViewer master) {
        return singleton.copy(master);
    }

    private HiViewerFactory() {
    }

    private HiViewer getViewer(HiViewerModel model) {
        for (HiViewerComponent hiViewerComponent : this.viewers) {
            if (!model.isSameDisplay(hiViewerComponent.getModel())) continue;
            hiViewerComponent.refresh();
            return hiViewerComponent;
        }
        HiViewerComponent hiViewerComponent = new HiViewerComponent(model);
        hiViewerComponent.initialize();
        hiViewerComponent.addChangeListener(this);
        this.viewers.add(hiViewerComponent);
        return hiViewerComponent;
    }

    private HiViewer copy(HiViewer master) {
        if (master == null) {
            throw new NullPointerException("No master.");
        }
        HiViewerComponent comp = (HiViewerComponent)master;
        HiViewerModel model = comp.getModel();
        HiViewerComponent newComp = new HiViewerComponent(model.reinstantiate());
        newComp.initialize();
        newComp.addChangeListener(this);
        this.viewers.add(comp);
        return newComp;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        HiViewerComponent comp = (HiViewerComponent)ce.getSource();
        if (comp.getState() == 6) {
            this.viewers.remove(comp);
        }
        if (this.viewers.size() == 0) {
            TaskBar tb = ImViewerAgent.getRegistry().getTaskBar();
            tb.removeFromMenu(0, this.windowMenu);
            this.isAttached = false;
        }
    }
}

