/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ActivationAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.AnnotateAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.AnnotateChildrenAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ClassifyAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ClassifyChildrenAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ClipBoardViewAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.DeclassifyAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ExitAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.FindAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.FindwSTAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.FlatLayoutAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.MouseOverAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.PropertiesAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.RefreshAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.RemoveAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ResetLayoutAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.RollOverAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.SaveLayoutAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.SaveThumbnailsAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ShowTitleBarAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.SortByAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.SquaryLayoutAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.TreeViewAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ViewAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ViewCGCIAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ViewPDIAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ZoomFitAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ZoomInAction;
import org.openmicroscopy.shoola.agents.hiviewer.actions.ZoomOutAction;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.SelectedNodeVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeView;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerFactory;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerWin;
import org.openmicroscopy.shoola.agents.hiviewer.view.ThumbWinManager;

class HiViewerControl
implements ChangeListener,
PropertyChangeListener {
    static final Integer EXIT = new Integer(0);
    static final Integer VIEW_PDI = new Integer(1);
    static final Integer VIEW_CGCI = new Integer(2);
    static final Integer FIND_W_ST = new Integer(3);
    static final Integer CLEAR = new Integer(4);
    static final Integer SQUARY = new Integer(5);
    static final Integer SHOW_TITLEBAR = new Integer(6);
    static final Integer SAVE = new Integer(7);
    static final Integer PROPERTIES = new Integer(8);
    static final Integer ANNOTATE = new Integer(9);
    static final Integer CLASSIFY = new Integer(10);
    static final Integer DECLASSIFY = new Integer(11);
    static final Integer VIEW = new Integer(12);
    static final Integer ZOOM_IN = new Integer(13);
    static final Integer ZOOM_OUT = new Integer(14);
    static final Integer ZOOM_FIT = new Integer(15);
    static final Integer REFRESH = new Integer(16);
    static final Integer SAVE_THUMB = new Integer(17);
    static final Integer TREE_VIEW = new Integer(18);
    static final Integer FIND = new Integer(20);
    static final Integer ROLL_OVER = new Integer(21);
    static final Integer REMOVE = new Integer(22);
    static final Integer CLIPBOARD_VIEW = new Integer(23);
    static final Integer FLAT_LAYOUT = new Integer(24);
    static final Integer SORT_BY_NAME = new Integer(25);
    static final Integer SORT_BY_DATE = new Integer(26);
    static final Integer ANNOTATE_CHILDREN = new Integer(27);
    static final Integer CLASSIFY_CHILDREN = new Integer(28);
    static final Integer RESET_LAYOUT = new Integer(29);
    static final Integer MOUSE_OVER = new Integer(30);
    private HiViewer model;
    private HiViewerWin view;
    private Map<Integer, Action> actionsMap;
    private int historyState;

    private void createActions() {
        this.actionsMap.put(EXIT, new ExitAction(this.model));
        this.actionsMap.put(VIEW_CGCI, new ViewCGCIAction(this.model));
        this.actionsMap.put(VIEW_PDI, new ViewPDIAction(this.model));
        this.actionsMap.put(REFRESH, new RefreshAction(this.model));
        this.actionsMap.put(SQUARY, new SquaryLayoutAction(this.model));
        this.actionsMap.put(SHOW_TITLEBAR, new ShowTitleBarAction(this.model));
        this.actionsMap.put(SAVE, new SaveLayoutAction(this.model));
        this.actionsMap.put(PROPERTIES, new PropertiesAction(this.model));
        this.actionsMap.put(ANNOTATE, new AnnotateAction(this.model));
        this.actionsMap.put(CLASSIFY, new ClassifyAction(this.model));
        this.actionsMap.put(DECLASSIFY, new DeclassifyAction(this.model));
        this.actionsMap.put(VIEW, new ViewAction(this.model));
        this.actionsMap.put(ZOOM_IN, new ZoomInAction(this.model));
        this.actionsMap.put(ZOOM_OUT, new ZoomOutAction(this.model));
        this.actionsMap.put(ZOOM_FIT, new ZoomFitAction(this.model));
        this.actionsMap.put(FIND_W_ST, new FindwSTAction(this.model));
        this.actionsMap.put(SAVE_THUMB, new SaveThumbnailsAction(this.model));
        this.actionsMap.put(TREE_VIEW, new TreeViewAction(this.model));
        this.actionsMap.put(FIND, new FindAction(this.model));
        this.actionsMap.put(ROLL_OVER, new RollOverAction(this.model));
        this.actionsMap.put(REMOVE, new RemoveAction(this.model));
        this.actionsMap.put(CLIPBOARD_VIEW, new ClipBoardViewAction(this.model));
        this.actionsMap.put(FLAT_LAYOUT, new FlatLayoutAction(this.model));
        this.actionsMap.put(SORT_BY_DATE, new SortByAction(this.model, 0));
        this.actionsMap.put(SORT_BY_NAME, new SortByAction(this.model, 1));
        this.actionsMap.put(CLASSIFY_CHILDREN, new ClassifyChildrenAction(this.model));
        this.actionsMap.put(ANNOTATE_CHILDREN, new AnnotateChildrenAction(this.model));
        this.actionsMap.put(RESET_LAYOUT, new ResetLayoutAction(this.model));
        this.actionsMap.put(MOUSE_OVER, new MouseOverAction(this.model));
    }

    private void createWindowsMenuItems(JMenu menu) {
        Set viewers = HiViewerFactory.getViewers();
        Iterator i = viewers.iterator();
        menu.removeAll();
        while (i.hasNext()) {
            menu.add(new JMenuItem(new ActivationAction((HiViewer)i.next())));
        }
    }

    private void attachListeners(JMenu menu) {
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    HiViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            public void menuKeyReleased(MenuKeyEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    HiViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuKeyPressed(MenuKeyEvent e) {
            }

            public void menuKeyTyped(MenuKeyEvent e) {
            }
        });
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                HiViewerControl.this.model.discard();
            }
        });
    }

    private void setViews() {
        Browser browser = this.model.getBrowser();
        browser.addPropertyChangeListener(this);
        this.model.getClipBoard().setDisplay(true);
        this.view.setViews(browser.getUI(), this.model.getClipBoard().getUI());
        this.view.setViewTitle();
    }

    HiViewerControl(HiViewer model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, Action>();
        this.createActions();
    }

    void initialize(HiViewerWin view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.historyState = -1;
        this.model.addChangeListener(this);
        this.attachListeners(HiViewerFactory.getWindowMenu());
        HiViewerFactory.attachWindowMenuToTaskBar();
    }

    Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void scrollToNode(ImageDisplay node) {
        ImageDisplay parent;
        if (node == null) {
            throw new IllegalArgumentException("No node.");
        }
        int x = 0;
        int y = 0;
        ImageDisplay n = parent;
        JScrollPane dskDecorator = null;
        Rectangle bounds = node.getBounds();
        for (parent = node.getParentDisplay(); parent != null; parent = parent.getParentDisplay()) {
            n = parent;
            dskDecorator = parent.getDeskDecorator();
            Rectangle viewRect = dskDecorator.getViewport().getViewRect();
            Rectangle nBounds = n.getBounds();
            x += nBounds.x;
            y += nBounds.y;
            if (viewRect.contains(bounds)) continue;
            dskDecorator.getVerticalScrollBar().setValue(bounds.y);
            dskDecorator.getHorizontalScrollBar().setValue(bounds.x);
        }
        if (dskDecorator == null) {
            return;
        }
        dskDecorator = n.getDeskDecorator();
        dskDecorator.getVerticalScrollBar().setValue(y + bounds.y);
        dskDecorator.getHorizontalScrollBar().setValue(x + bounds.x);
    }

    public void stateChanged(ChangeEvent ce) {
        int state = this.model.getState();
        switch (state) {
            case 3: {
                this.setViews();
                break;
            }
            case 5: {
                if (this.historyState != 2) break;
                this.setViews();
                break;
            }
            case 6: {
                ThumbWinManager.rollOverDisplay(null, null);
                this.view.setVisible(false);
                this.view.dispose();
            }
        }
        this.historyState = state;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if ("popupPoint".equals(propName)) {
            Browser browser = this.model.getBrowser();
            if (browser == null) {
                return;
            }
            ImageDisplay d = browser.getLastSelectedDisplay();
            Point p = browser.getPopupPoint();
            if (d != null && p != null) {
                this.view.showPopup(d, p);
            }
        } else if ("thumbSelected".equals(propName)) {
            ImageNode d = (ImageNode)pce.getNewValue();
            if (d != null) {
                ThumbWinManager.display(d, this.model);
            }
        } else if ("selectedDisplay".equals(propName)) {
            TreeView treeView = this.model.getTreeView();
            if (treeView == null) {
                return;
            }
            Browser browser = this.model.getBrowser();
            if (browser == null) {
                return;
            }
            ImageDisplay d = browser.getLastSelectedDisplay();
            if (d != null) {
                treeView.accept(new SelectedNodeVisitor(treeView, d));
            }
        } else if ("treePopupPoint".equals(propName)) {
            TreeView treeView = this.model.getTreeView();
            if (treeView == null) {
                return;
            }
            Point p = treeView.getPopupPoint();
            if (p != null) {
                this.view.showPopup((JComponent)pce.getNewValue(), p);
            }
        } else if ("close".equals(propName)) {
            this.model.showTreeView(false);
        } else if ("treeSelectedDisplay".equals(propName)) {
            TreeView treeView = this.model.getTreeView();
            if (treeView == null) {
                return;
            }
            Browser browser = this.model.getBrowser();
            ImageDisplay[] nodes = (ImageDisplay[])pce.getNewValue();
            if (nodes != null) {
                if (nodes.length == 1) {
                    ImageDisplay img = nodes[0];
                    if (!img.equals(browser.getLastSelectedDisplay())) {
                        browser.setSelectedDisplay(img);
                    }
                } else {
                    browser.setSelectedDisplays(nodes);
                }
            } else {
                browser.setSelectedDisplay(null);
            }
        } else if ("scrollToNode".equals(propName)) {
            this.scrollToNode((ImageDisplay)pce.getNewValue());
        } else if ("annotatedNode".equals(propName)) {
            ImageDisplay n = (ImageDisplay)pce.getNewValue();
            this.model.getClipBoard().setSelectedPane(0, n);
            this.model.getBrowser().setSelectedDisplay(n);
        } else if ("classifiedNode".equals(propName)) {
            ImageDisplay n = (ImageDisplay)pce.getNewValue();
            this.model.getClipBoard().setSelectedPane(1, n);
            this.model.getBrowser().setSelectedDisplay(n);
        } else if ("rollOver".equals(propName)) {
            if (this.model.isRollOver()) {
                ImageDisplay n = (ImageDisplay)pce.getNewValue();
                if (n instanceof ImageNode) {
                    ThumbWinManager.rollOverDisplay((ImageNode)n, this.model.getBrowser());
                } else {
                    ThumbWinManager.rollOverDisplay(null, this.model.getBrowser());
                }
            }
        } else if ("removeRollOver".equals(propName) || "removeNodeRollOver".equals(propName)) {
            if (this.model.isRollOver()) {
                ThumbWinManager.rollOverDisplay(null, this.model.getBrowser());
            }
        } else if (propName.equals("annotated")) {
            if (this.view.getDataHandler() == null) {
                return;
            }
            this.model.onDataObjectSave((List)pce.getNewValue());
            this.view.discardDataHandler();
        } else if (propName.equals("classified")) {
            if (this.view.getDataHandler() == null) {
                return;
            }
            if (pce.getNewValue() != null) {
                Set set = (Set)pce.getNewValue();
                ArrayList l = new ArrayList(set.size());
                Iterator i = set.iterator();
                while (i.hasNext()) {
                    l.add(i.next());
                }
                this.model.onDataObjectSave(l);
            }
            this.view.discardDataHandler();
        }
    }
}

