/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.hiviewer.HiTranslator;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.clipboard.ClipBoard;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.AnnotateCmd;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.DataSaveVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.layout.Layout;
import org.openmicroscopy.shoola.agents.hiviewer.layout.LayoutFactory;
import org.openmicroscopy.shoola.agents.hiviewer.saver.ContainerSaver;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeView;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewer;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerControl;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerModel;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerWin;
import org.openmicroscopy.shoola.agents.hiviewer.view.ThumbWinManager;
import org.openmicroscopy.shoola.agents.util.DataHandler;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;

class HiViewerComponent
extends AbstractComponent
implements HiViewer {
    private HiViewerModel model;
    private HiViewerWin view;
    private HiViewerControl controller;

    HiViewerComponent(HiViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new HiViewerControl(this);
        this.view = new HiViewerWin();
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model);
    }

    HiViewerModel getModel() {
        return this.model;
    }

    public int getState() {
        return this.model.getState();
    }

    public int getHierarchyType() {
        return this.model.getHierarchyType();
    }

    public void activate(Rectangle bounds) {
        switch (this.model.getState()) {
            case 1: {
                this.model.fireHierarchyLoading(false);
                this.view.setComponentBounds(bounds);
                this.fireStateChange();
                break;
            }
            case 6: {
                break;
            }
            default: {
                this.view.deIconify();
            }
        }
    }

    public void setHierarchyRoots(Set roots, boolean flat, boolean refresh) {
        if (this.model.getState() != 2) {
            throw new IllegalStateException("This method can only be invoked in the LOADING_HIERARCHY state.");
        }
        if (!refresh) {
            this.model.createBrowser(roots, flat);
            this.model.createClipBoard();
            this.model.getClipBoard().addPropertyChangeListener(this.controller);
            this.model.fireThumbnailLoading();
            if (this.model.getBrowser().getImages().size() == 0) {
                this.setStatus("Done", -1);
            } else {
                this.setStatus("Painting container tree", -1);
            }
            this.fireStateChange();
        } else {
            Browser browser = this.model.getBrowser();
            if (browser == null) {
                throw new NullPointerException("The browser cannot be NULL.");
            }
            boolean isClipBoardDisplay = false;
            ClipBoard clipBoard = this.model.getClipBoard();
            if (clipBoard != null) {
                isClipBoardDisplay = clipBoard.isDisplay();
            }
            this.view.setCursor(Cursor.getPredefinedCursor(3));
            this.model.refreshBrowser(roots, flat);
            this.model.createClipBoard();
            this.model.getClipBoard().addPropertyChangeListener(this.controller);
            this.model.fireThumbnailLoading();
            if (this.model.getBrowser().getImages().size() == 0) {
                this.setStatus("Done", -1);
            } else {
                this.setStatus("Painting container tree", -1);
            }
            this.fireStateChange();
            this.model.getBrowser().setSelectedDisplay(null);
            TreeView tv = this.model.getTreeView();
            if (tv != null) {
                this.model.createTreeView();
                this.view.showTreeView(tv.isDisplay());
            }
            this.view.showClipBoard(isClipBoardDisplay);
            this.view.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setThumbnail(long imageID, BufferedImage thumb) {
        int state = this.model.getState();
        switch (state) {
            case 3: {
                this.model.setThumbnail(imageID, thumb);
                if (this.model.getState() != 5) break;
                this.fireStateChange();
                break;
            }
            case 5: {
                this.model.setThumbnail(imageID, thumb);
                break;
            }
            default: {
                throw new IllegalStateException("This method can only be invoked in the LOADING_THUMBNAILS or READY state.");
            }
        }
    }

    public void setStatus(String description, int perc) {
        int state = this.model.getState();
        if (state == 2 || state == 3) {
            this.view.setStatus(description, false, perc);
        } else {
            this.view.setStatus(description, true, perc);
        }
    }

    public Browser getBrowser() {
        switch (this.model.getState()) {
            case 1: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the NEW or DISCARDED state.");
            }
        }
        return this.model.getBrowser();
    }

    public void discard() {
        if (this.model.getState() != 6) {
            this.model.discard();
            this.fireStateChange();
        }
    }

    public JFrame getUI() {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view;
    }

    public String getViewTitle() {
        switch (this.model.getState()) {
            case 1: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the NEW or DISCARDED state.");
            }
        }
        return this.view.getViewTitle();
    }

    public ClipBoard getClipBoard() {
        switch (this.model.getState()) {
            case 1: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the NEW or DISCARDED state.");
            }
        }
        return this.model.getClipBoard();
    }

    public ExperimenterData getUserDetails() {
        return this.model.getUserDetails();
    }

    public void showTreeView(boolean b) {
        int state = this.model.getState();
        if (state == 1 && state == 6) {
            throw new IllegalStateException("This method cannot be invoked in the NEW or DISCARDED state.");
        }
        if (this.getBrowser() == null) {
            return;
        }
        TreeView treeView = this.model.getTreeView();
        if (treeView == null) {
            this.model.createTreeView();
            treeView = this.model.getTreeView();
            treeView.addPropertyChangeListener(this.controller);
        }
        if (treeView.isDisplay() == b) {
            return;
        }
        treeView.setDisplay(b);
        this.view.showTreeView(b);
    }

    public void showClipBoard(boolean b) {
        int state = this.model.getState();
        if (state == 1 && state == 6) {
            throw new IllegalStateException("This method cannot be invoked in the NEW or DISCARDED state.");
        }
        ClipBoard cb = this.model.getClipBoard();
        if (cb == null) {
            return;
        }
        if (cb.isDisplay() == b) {
            return;
        }
        cb.setDisplay(b);
        this.view.showClipBoard(b);
    }

    public TreeView getTreeView() {
        int state = this.model.getState();
        if (state == 1 && state == 6) {
            throw new IllegalStateException("This method cannot be invoked in the NEW or DISCARDED state.");
        }
        return this.model.getTreeView();
    }

    public TreeView createTreeView() {
        int state = this.model.getState();
        if (state == 1 && state == 6) {
            throw new IllegalStateException("This method cannot be invoked in the NEW or DISCARDED state.");
        }
        TreeView treeView = this.model.getTreeView();
        if (treeView == null) {
            this.model.createTreeView();
            treeView = this.model.getTreeView();
            treeView.addPropertyChangeListener(this.controller);
        }
        return treeView;
    }

    public long getRootID() {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getRootID();
    }

    public void moveToBack() {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.view.toBack();
    }

    public Object getHierarchyObject() {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        ImageDisplay node = this.model.getBrowser().getLastSelectedDisplay();
        if (node == null) {
            return null;
        }
        return node.getHierarchyObject();
    }

    public void scrollToNode(ImageDisplay node) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (node == null) {
            throw new IllegalArgumentException("No node.");
        }
        this.controller.scrollToNode(node);
    }

    public boolean isObjectReadable(DataObject ho) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return HiTranslator.isReadable(ho, this.getUserDetails().getId(), this.getRootID());
    }

    public boolean isObjectWritable(DataObject ho) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return HiTranslator.isWritable(ho, this.getUserDetails().getId(), this.getRootID());
    }

    public void saveObject(DataObject object) {
        if (object == null) {
            throw new IllegalArgumentException("No object to update");
        }
        this.model.fireDataObjectUpdate(object);
    }

    public void showProperties(DataObject object) {
        if (object == null) {
            throw new IllegalArgumentException("No object to update");
        }
        this.model.getClipBoard().showProperties(object);
    }

    public void setRollOver(boolean b) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.setRollOver(b);
    }

    public boolean isRollOver() {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.isRollOver();
    }

    public void removeObjects(List toRemove) {
        if (toRemove == null || toRemove.size() == 0) {
            UserNotifier un = HiViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Node remoal", "No nodes to remove.");
            return;
        }
        this.model.fireDataObjectsRemoval(toRemove);
        this.fireStateChange();
    }

    public void setLayout(int layoutIndex) {
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = this.getBrowser();
        switch (layoutIndex) {
            case 1: {
                browser.setSelectedLayout(layoutIndex);
                browser.resetChildDisplay();
                browser.accept(LayoutFactory.createLayout(1, this.model.getSorter()), 1);
                break;
            }
            case 2: {
                browser.setSelectedLayout(layoutIndex);
                browser.resetChildDisplay();
                Layout l = LayoutFactory.createLayout(layoutIndex, this.model.getSorter());
                browser.accept(l);
                browser.setSelectedLayout(2);
                l.doLayout();
            }
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void sortBy(int index) {
        this.model.getSorter().setByDate(0 == index);
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = this.getBrowser();
        switch (browser.getSelectedLayout()) {
            case 1: {
                browser.accept(LayoutFactory.createLayout(1, this.model.getSorter()), 1);
                break;
            }
            case 2: {
                browser.resetChildDisplay();
                Layout l = LayoutFactory.createLayout(2, this.model.getSorter());
                browser.accept(l);
                l.doLayout();
            }
        }
        TreeView tv = this.model.getTreeView();
        if (tv != null) {
            tv.sortNodes(index, (ImageDisplay)this.model.getBrowser().getUI());
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void layoutZoomedNodes() {
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = this.getBrowser();
        if (browser == null) {
            return;
        }
        ImageDisplay d = browser.getLastSelectedDisplay();
        switch (browser.getSelectedLayout()) {
            case 1: {
                d.accept(LayoutFactory.createLayout(1, this.model.getSorter()), 1);
                break;
            }
            case 2: {
                browser.resetChildDisplay();
                Layout l = LayoutFactory.createLayout(2, this.model.getSorter());
                browser.accept(l);
                l.doLayout();
            }
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setFoundResults(Set foundNodes) {
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        List l = this.model.getSorter().sort(foundNodes);
        this.model.getClipBoard().setFoundResults(l);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void annotateDataObjects(Set nodes) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (nodes == null) {
            throw new IllegalArgumentException("No dataObject to annotate");
        }
        if (nodes.size() == 1) {
            AnnotateCmd cmd = new AnnotateCmd(this, null);
            cmd.execute();
            return;
        }
        DataHandler dh = this.model.annotateDataObjects(this.view, nodes);
        dh.addPropertyChangeListener(this.controller);
        dh.activate();
    }

    public void classifyImages(ImageData[] images, int mode) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (images == null || images.length == 0) {
            throw new IllegalArgumentException("No image to classify.");
        }
        DataHandler dh = this.model.classifyImageObjects(this.view, images, mode);
        dh.addPropertyChangeListener(this.controller);
        dh.activate();
    }

    public void onDataObjectSave(List nodes) {
        switch (this.model.getState()) {
            case 1: 
            case 3: 
            case 6: {
                return;
            }
        }
        if (nodes == null) {
            this.model.onDataObjectSave();
            this.fireStateChange();
            return;
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        DataSaveVisitor visitor = new DataSaveVisitor(this, nodes);
        Browser browser = this.model.getBrowser();
        browser.accept(visitor);
        JComponent c = browser.getUI();
        c.validate();
        c.repaint();
        browser.setSelectedDisplay(browser.getLastSelectedDisplay());
        TreeView tv = this.model.getTreeView();
        if (tv != null) {
            tv.repaint();
        }
        ThumbWinManager.updateDisplayNodes(nodes);
        this.model.onDataObjectSave();
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.fireStateChange();
    }

    public void refresh() {
        switch (this.model.getState()) {
            case 6: {
                throw new IllegalStateException("This method cannot beinvoked in the DISCARDED state.");
            }
            case 1: {
                return;
            }
        }
        this.model.fireHierarchyLoading(true);
        this.fireStateChange();
    }

    public void saveThumbnails(Set thumbnails) {
        if (thumbnails == null || thumbnails.size() == 0) {
            throw new IllegalArgumentException("No images to save.");
        }
        List l = this.model.getSorter().sort(thumbnails);
        Iterator i = l.iterator();
        ArrayList<BufferedImage> thumbs = new ArrayList<BufferedImage>(l.size());
        while (i.hasNext()) {
            thumbs.add(((ImageNode)i.next()).getThumbnail().getDisplayedImage());
        }
        ContainerSaver saver = new ContainerSaver(this.view, thumbs);
        saver.pack();
        UIUtilities.centerAndShow(saver);
    }

    public long getUserGroupID() {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getUserGroupID();
    }

    public ExperimenterData getExperimenter() {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getExperimenter();
    }

    public void annotateChildren(ImageDisplay node) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (node == null) {
            throw new IllegalArgumentException("No specified container.");
        }
        DataHandler dh = this.model.annotateChildren(this.view, node);
        dh.addPropertyChangeListener(this.controller);
        dh.activate();
    }

    public void classifyChildren(ImageDisplay node) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (node == null) {
            throw new IllegalArgumentException("No specified container.");
        }
        DataHandler dh = this.model.classifyChildren(this.view, node);
        dh.addPropertyChangeListener(this.controller);
        dh.activate();
    }

    public void resetLayout() {
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = this.getBrowser();
        switch (this.model.getBrowser().getSelectedLayout()) {
            case 1: {
                browser.accept(LayoutFactory.createLayout(1, this.model.getSorter()), 1);
                break;
            }
            case 2: {
                browser.resetChildDisplay();
                Layout l = LayoutFactory.createLayout(2, this.model.getSorter());
                browser.accept(l);
                l.doLayout();
            }
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean isMouseOver() {
        return this.model.isMouseOver();
    }

    public void mouseOver(boolean b) {
        this.model.setMouseOver(b);
    }
}

