/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.DataLoader;
import org.openmicroscopy.shoola.agents.hiviewer.DatasetLoader;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatasetModel
extends HiViewerModel {
    private Set<Long> datasetsID;

    DatasetModel(long datasetID) {
        this.datasetsID = new HashSet<Long>(1);
        this.datasetsID.add(new Long(datasetID));
    }

    DatasetModel(Set<Long> datasetsID) {
        this.datasetsID = datasetsID;
    }

    @Override
    protected int getHierarchyType() {
        return 102;
    }

    @Override
    protected boolean isSameDisplay(HiViewerModel other) {
        if (other == null || !(other instanceof DatasetModel)) {
            return false;
        }
        DatasetModel dm = (DatasetModel)other;
        if (dm.getHierarchyType() != this.getHierarchyType()) {
            return false;
        }
        if (dm.datasetsID.size() != this.datasetsID.size()) {
            return false;
        }
        Iterator<Long> i = dm.datasetsID.iterator();
        int index = this.datasetsID.size();
        while (i.hasNext()) {
            Long id = i.next();
            Iterator<Long> j = this.datasetsID.iterator();
            while (j.hasNext()) {
                if (id.longValue() != j.next().longValue()) continue;
                --index;
            }
        }
        return index == 0;
    }

    @Override
    protected DataLoader createHierarchyLoader(boolean refresh) {
        return new DatasetLoader(this.component, this.datasetsID, refresh);
    }

    @Override
    protected HiViewerModel reinstantiate() {
        DatasetModel model = new DatasetModel(this.datasetsID);
        model.setRootLevel(this.getExperimenter(), this.getUserGroupID());
        return model;
    }
}

