/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.CategoryLoader;
import org.openmicroscopy.shoola.agents.hiviewer.DataLoader;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CategoryModel
extends HiViewerModel {
    private Set<Long> categoriesID;

    CategoryModel(long categoryID) {
        this.categoriesID = new HashSet<Long>(1);
        this.categoriesID.add(new Long(categoryID));
    }

    CategoryModel(Set<Long> categoriesID) {
        this.categoriesID = categoriesID;
    }

    @Override
    protected int getHierarchyType() {
        return 104;
    }

    @Override
    protected boolean isSameDisplay(HiViewerModel other) {
        if (other == null || !(other instanceof CategoryModel)) {
            return false;
        }
        CategoryModel cm = (CategoryModel)other;
        if (cm.getHierarchyType() != this.getHierarchyType()) {
            return false;
        }
        if (cm.categoriesID.size() != this.categoriesID.size()) {
            return false;
        }
        Iterator<Long> i = cm.categoriesID.iterator();
        int index = this.categoriesID.size();
        while (i.hasNext()) {
            Long id = i.next();
            Iterator<Long> j = this.categoriesID.iterator();
            while (j.hasNext()) {
                if (id.longValue() != j.next().longValue()) continue;
                --index;
            }
        }
        return index == 0;
    }

    @Override
    protected DataLoader createHierarchyLoader(boolean refresh) {
        return new CategoryLoader(this.component, this.categoriesID, refresh);
    }

    @Override
    protected HiViewerModel reinstantiate() {
        CategoryModel model = new CategoryModel(this.categoriesID);
        model.setRootLevel(this.getExperimenter(), this.getUserGroupID());
        return model;
    }
}

