/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.view;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.hiviewer.CategoryGroupLoader;
import org.openmicroscopy.shoola.agents.hiviewer.DataLoader;
import org.openmicroscopy.shoola.agents.hiviewer.view.HiViewerModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CategoryGroupModel
extends HiViewerModel {
    private Set<Long> ids;

    CategoryGroupModel(long cgID) {
        this.ids = new HashSet<Long>(1);
        this.ids.add(new Long(cgID));
    }

    CategoryGroupModel(Set<Long> ids) {
        this.ids = ids;
    }

    @Override
    protected int getHierarchyType() {
        return 103;
    }

    @Override
    protected boolean isSameDisplay(HiViewerModel other) {
        if (other == null || !(other instanceof CategoryGroupModel)) {
            return false;
        }
        CategoryGroupModel cgm = (CategoryGroupModel)other;
        if (cgm.getHierarchyType() != this.getHierarchyType()) {
            return false;
        }
        if (cgm.ids.size() != this.ids.size()) {
            return false;
        }
        Iterator<Long> i = cgm.ids.iterator();
        int index = this.ids.size();
        while (i.hasNext()) {
            Long id = i.next();
            Iterator<Long> j = this.ids.iterator();
            while (j.hasNext()) {
                if (id.longValue() != j.next().longValue()) continue;
                --index;
            }
        }
        return index == 0;
    }

    @Override
    protected DataLoader createHierarchyLoader(boolean refresh) {
        return new CategoryGroupLoader(this.component, this.ids, refresh);
    }

    @Override
    protected HiViewerModel reinstantiate() {
        CategoryGroupModel model = new CategoryGroupModel(this.ids);
        model.setRootLevel(this.getExperimenter(), this.getUserGroupID());
        return model;
    }
}

