/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewNode;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private boolean visibleColor;
    private boolean thumbnail;
    private IconManager icons;

    private void setTextColor(Color c) {
        if (c == null) {
            return;
        }
        if (UIUtilities.isDarkColor(c)) {
            this.setForeground(UIUtilities.DEFAULT_TEXT);
        }
    }

    private void setValues(Object usrObject, Icon icon) {
        if (usrObject instanceof ProjectData) {
            if (icon == null) {
                icon = this.icons.getIcon(22);
            }
            this.setIcon(icon);
        } else if (usrObject instanceof DatasetData) {
            DatasetData data = (DatasetData)usrObject;
            if (icon == null) {
                Long i = data.getAnnotationCount();
                icon = i == null || i == 0L ? this.icons.getIcon(23) : this.icons.getIcon(41);
            }
            this.setIcon(icon);
        } else if (usrObject instanceof ImageData) {
            if (icon == null) {
                if (this.thumbnail) {
                    icon = this.icons.getIcon(36);
                } else {
                    ImageData img = (ImageData)usrObject;
                    Long a = img.getAnnotationCount();
                    Long c = img.getClassificationCount();
                    long n = 0L;
                    long m = 0L;
                    if (a != null) {
                        n = a;
                    }
                    if (c != null) {
                        m = c;
                    }
                    if (n == 0L && m == 0L) {
                        icon = this.icons.getIcon(26);
                    } else if (n != 0L && m == 0L) {
                        icon = this.icons.getIcon(42);
                    } else if (n == 0L && m != 0L) {
                        icon = this.icons.getIcon(43);
                    } else if (n != 0L && m != 0L) {
                        icon = this.icons.getIcon(44);
                    }
                }
            }
            this.setIcon(icon);
        } else if (usrObject instanceof CategoryGroupData) {
            if (icon == null) {
                icon = this.icons.getIcon(24);
            }
            this.setIcon(icon);
        } else if (usrObject instanceof CategoryData) {
            if (icon == null) {
                icon = this.icons.getIcon(25);
            }
            this.setIcon(icon);
        } else if (usrObject instanceof String) {
            this.setIcon(null);
        }
    }

    public TreeCellRenderer() {
        this(false, false);
    }

    public TreeCellRenderer(boolean visibleColor, boolean thumbnail) {
        this.visibleColor = visibleColor;
        this.thumbnail = thumbnail;
        this.icons = IconManager.getInstance();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getLevel() == 0) {
            this.setIcon(this.icons.getIcon(21));
            if (sel) {
                this.setTextColor(this.getBackgroundSelectionColor());
            }
            return this;
        }
        Object usrObject = node.getUserObject();
        Color c = null;
        int w = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (usrObject instanceof ImageSet) {
            ImageSet set = (ImageSet)usrObject;
            if (node instanceof TreeViewNode) {
                w += fm.stringWidth(((TreeViewNode)node).getNodeName());
                this.setText(((TreeViewNode)node).toString());
            } else {
                this.setText(set.toString());
                w += fm.stringWidth(this.getText());
            }
            this.setValues(set.getHierarchyObject(), null);
            if (this.visibleColor) {
                c = ((ImageSet)usrObject).getHighlight();
                if (c == null) {
                    c = this.getForeground();
                }
                this.setForeground(c);
            }
        } else if (usrObject instanceof ImageNode) {
            ImageNode imgNode = (ImageNode)usrObject;
            w += fm.stringWidth(imgNode.toString());
            if (node instanceof TreeViewNode) {
                w += fm.stringWidth(((TreeViewNode)node).getNodeName());
                this.setText(((TreeViewNode)node).toString());
            } else {
                this.setText(imgNode.toString());
                w += fm.stringWidth(this.getText());
            }
            if (this.thumbnail) {
                this.setValues(imgNode.getHierarchyObject(), imgNode.getThumbnail().getIcon());
            } else {
                this.setValues(imgNode.getHierarchyObject(), null);
            }
            if (this.visibleColor) {
                c = imgNode.getHighlight();
                if (c == null) {
                    c = this.getForeground();
                }
                this.setForeground(c);
            }
        } else {
            this.setText(node.toString());
            this.setValues(usrObject, null);
            w += fm.stringWidth(this.getText());
        }
        if (this.getIcon() != null) {
            w += this.getIcon().getIconWidth();
        }
        this.setPreferredSize(new Dimension(w += this.getIconTextGap(), fm.getHeight()));
        if (sel) {
            this.setTextColor(this.getBackgroundSelectionColor());
        }
        return this;
    }
}

