/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.hiviewer.util.RollOverCanvas;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import pojos.DataObject;

public class RollOverWin
extends JDialog {
    static final int MINIMUM_ZOOM = 1;
    static final int MAXIMUM_ZOOM = 2;
    private ImageNode node;
    private BufferedImage image;
    private BufferedImage originalImage;
    private RollOverCanvas canvas;
    private Browser browser;
    private float zoomFactor;

    private void setProperties() {
        this.setModal(false);
        this.setResizable(false);
        this.setUndecorated(true);
        this.zoomFactor = 1.0f;
    }

    private void makeComponentsSize(int w, int h) {
        if (this.canvas == null) {
            return;
        }
        Insets i = this.canvas.getInsets();
        Dimension d = new Dimension(w + i.right + i.left, h + i.top + i.bottom);
        this.canvas.setPreferredSize(d);
        this.canvas.setSize(d);
    }

    private void buildUI() {
        Container container = this.getContentPane();
        container.add((Component)this.canvas, "Center");
    }

    public RollOverWin(JFrame parent, Browser browser) {
        if (browser == null) {
            throw new IllegalArgumentException("No browser.");
        }
        this.browser = browser;
        IconManager icons = IconManager.getInstance();
        this.canvas = new RollOverCanvas(this, icons.getImageIcon(IconManager.PIN));
        this.setProperties();
        this.buildUI();
    }

    void magnifyImage(int tick) {
        this.zoomFactor -= 0.1f * (float)tick;
        this.zoomFactor = (float)Math.round(this.zoomFactor * 10.0f) / 10.0f;
        if (this.zoomFactor < 1.0f) {
            this.zoomFactor = 1.0f;
        }
        if (this.zoomFactor > 2.0f) {
            this.zoomFactor = 2.0f;
        }
        this.image = Factory.magnifyImage(this.zoomFactor, this.originalImage);
        this.makeComponentsSize(this.image.getWidth(), this.image.getHeight());
        this.pack();
    }

    void pinThumbnail() {
        this.browser.setThumbSelected(true, this.node);
    }

    void annotate() {
        this.node.fireAnnotation();
    }

    void classify() {
        this.node.fireClassification();
    }

    void viewImage() {
        ViewCmd cmd = new ViewCmd((DataObject)this.node.getHierarchyObject());
        cmd.execute();
    }

    BufferedImage getImage() {
        return this.image;
    }

    public void setImageNode(ImageNode node) {
        if (node == null) {
            throw new IllegalArgumentException("No node.");
        }
        this.node = node;
        IconManager icons = IconManager.getInstance();
        ImageIcon annotatedIcon = null;
        if (node.isAnnotated()) {
            annotatedIcon = icons.getImageIcon(8);
        }
        ImageIcon classifiedIcon = null;
        if (node.isClassified()) {
            classifiedIcon = icons.getImageIcon(15);
        }
        this.canvas.initialize(annotatedIcon, classifiedIcon);
        Thumbnail prv = node.getThumbnail();
        BufferedImage full = prv.getFullScaleThumb();
        if (prv.getScalingFactor() == 1.0) {
            full = prv.getZoomedFullScaleThumb();
        }
        if (full != null) {
            this.image = full;
            this.originalImage = full;
            this.makeComponentsSize(this.image.getWidth(), this.image.getHeight());
            this.canvas.repaint();
        }
    }

    public void close() {
        this.setVisible(true);
        this.dispose();
    }

    public void moveToFront(Point p) {
        this.moveToFront(p.x, p.y);
    }

    public void moveToFront(int x, int y) {
        this.setLocation(x, y);
        this.setVisible(true);
    }
}

