/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.hiviewer.util.RollOverWin;

class RollOverCanvas
extends JComponent {
    static final Color INNER_BORDER_HIGHLIGHT = new Color(240, 240, 240);
    static final Color INNER_BORDER_SHADOW = new Color(200, 200, 200);
    private final RollOverWin model;
    private ImageIcon pinIcon;
    private ImageIcon annotatedIcon;
    private ImageIcon classifiedIcon;
    private Rectangle pinRectangle;
    private Rectangle annotatedRectangle;
    private Rectangle classifiedRectangle;

    RollOverCanvas(RollOverWin m, ImageIcon pinIcon) {
        if (m == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (pinIcon == null) {
            throw new IllegalArgumentException("No pin.");
        }
        this.model = m;
        this.pinIcon = pinIcon;
        this.pinRectangle = new Rectangle();
        this.annotatedRectangle = new Rectangle();
        this.classifiedRectangle = new Rectangle();
        this.setOpaque(false);
        this.setBorder(BorderFactory.createBevelBorder(1, INNER_BORDER_HIGHLIGHT, INNER_BORDER_SHADOW));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                if (RollOverCanvas.this.pinRectangle.contains(p)) {
                    RollOverCanvas.this.model.pinThumbnail();
                } else if (RollOverCanvas.this.annotatedRectangle.contains(p)) {
                    RollOverCanvas.this.model.annotate();
                } else if (RollOverCanvas.this.classifiedRectangle.contains(p)) {
                    RollOverCanvas.this.model.classify();
                }
                if (e.getClickCount() == 2) {
                    RollOverCanvas.this.model.viewImage();
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                RollOverCanvas.this.model.magnifyImage(e.getWheelRotation());
            }
        });
    }

    void initialize(ImageIcon annotatedIcon, ImageIcon classifiedIcon) {
        this.annotatedIcon = annotatedIcon;
        this.classifiedIcon = classifiedIcon;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        if (this.model.getImage() != null) {
            Insets i = this.getInsets();
            int x = i.left + 1;
            int y = i.top + 1;
            g2D.drawImage(this.model.getImage(), null, x, y);
            int w = this.getWidth();
            int width = this.pinIcon.getIconWidth();
            int height = this.pinIcon.getIconHeight();
            this.pinRectangle.setBounds(w - width - 5, y, width, height);
            g2D.drawImage(this.pinIcon.getImage(), w - width - 5, y, width, height, null);
            if (this.annotatedIcon != null) {
                width = this.annotatedIcon.getIconWidth();
                height = this.annotatedIcon.getIconHeight();
                this.annotatedRectangle.setBounds(x, y, width, height);
                g2D.drawImage(this.annotatedIcon.getImage(), x, y, width, height, null);
                x += this.annotatedIcon.getIconWidth() + 2;
            }
            if (this.classifiedIcon != null) {
                width = this.classifiedIcon.getIconWidth();
                height = this.classifiedIcon.getIconHeight();
                this.classifiedRectangle.setBounds(x, y, width, height);
                g2D.drawImage(this.classifiedIcon.getImage(), x, y, width, height, null);
            }
        }
    }
}

