/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.treeview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.CollapseButton;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.PartialNameButton;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeView;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewNode;
import org.openmicroscopy.shoola.agents.hiviewer.util.TreeCellRenderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import pojos.DataObject;
import pojos.ImageData;

class TreeViewUI {
    private ViewerSorter sorter;
    private JTree tree;
    private JToolBar toolBar;
    private JPanel menuBar;
    private int numberImages;
    private TreeSelectionListener selectionListener;
    private TreeView model;

    private void createToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setBorder(null);
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.toolBar.add(new PartialNameButton(this.model));
        this.toolBar.add(new JSeparator(1));
        this.toolBar.add(new CollapseButton(this.model));
    }

    private void createMenuBar() {
        this.menuBar = new JPanel();
        this.menuBar.setBorder(BorderFactory.createEtchedBorder());
        this.menuBar.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 3, 3, 3);
        JLabel label = new JLabel();
        String s = " image";
        if (this.numberImages > 1) {
            s = s + "s";
        }
        label.setText("Contains " + this.numberImages + s + ".");
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(2, 0, 0));
        p.add(label);
        p.add(Box.createRigidArea(new Dimension(5, label.getSize().height)));
        p.add(this.toolBar);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        this.menuBar.add((Component)label, c);
        label.setLabelFor(p);
        c.gridx = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.menuBar.add((Component)p, c);
    }

    private void buildTreeNode(TreeViewNode parent, List nodes) {
        DefaultTreeModel tm = (DefaultTreeModel)this.tree.getModel();
        Iterator i = nodes.iterator();
        TreeViewNode dtn = null;
        parent.removeAllChildrenNode();
        parent.removeAllChildren();
        while (i.hasNext()) {
            ImageDisplay imageDisplay = (ImageDisplay)i.next();
            if (imageDisplay instanceof ImageNode) {
                ++this.numberImages;
                dtn = new TreeViewImageNode(imageDisplay);
            } else {
                dtn = new TreeViewImageSet(imageDisplay);
            }
            parent.addChildNode(dtn);
            tm.insertNodeInto(dtn, parent, parent.getChildCount());
            Set children = imageDisplay.getChildrenDisplay();
            if (children.size() == 0) continue;
            this.buildTreeNode(dtn, this.sorter.sort(children));
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tm.getRoot();
        if (parent == root && dtn != null) {
            this.tree.collapsePath(new TreePath(dtn.getPath()));
        }
    }

    private TreeViewImageSet createTree(ImageDisplay node) {
        this.tree = new JTree();
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new TreeCellRenderer(true, false));
        this.tree.getSelectionModel().setSelectionMode(4);
        TreeViewImageSet root = new TreeViewImageSet(node);
        this.tree.setRootVisible(false);
        this.tree.setModel(new DefaultTreeModel(root));
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreeViewUI.this.onClick(e, false);
            }

            public void mouseReleased(MouseEvent e) {
                TreeViewUI.this.onClick(e, true);
            }

            public void mouseEntered(MouseEvent e) {
                TreeViewUI.this.model.removeRollOver();
            }
        });
        this.selectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreeViewUI.this.onClick();
            }
        };
        this.tree.addTreeSelectionListener(this.selectionListener);
        return root;
    }

    private void onClick() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        int n = paths.length;
        if (n == 0) {
            return;
        }
        ArrayList<TreeViewNode> nodes = new ArrayList<TreeViewNode>();
        for (int i = 0; i < n; ++i) {
            Object node = paths[i].getLastPathComponent();
            if (!(node instanceof TreeViewNode)) continue;
            nodes.add((TreeViewNode)node);
        }
        DefaultMutableTreeNode last = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        this.model.setSelectedDisplays(nodes, (TreeViewNode)last);
    }

    private void onClick(MouseEvent me, boolean released) {
        Point p = me.getPoint();
        int row = this.tree.getRowForLocation(p.x, p.y);
        if (row != -1) {
            DefaultMutableTreeNode node;
            ImageDisplay d;
            int n = me.getClickCount();
            if (n == 1) {
                if (me.isPopupTrigger()) {
                    this.model.setPopupPoint(p);
                }
            } else if (n == 2 && released && (d = (ImageDisplay)(node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()).getUserObject()) instanceof ImageNode) {
                ViewCmd cmd = new ViewCmd((DataObject)((ImageData)d.getHierarchyObject()));
                cmd.execute();
            }
        }
    }

    TreeViewUI(TreeView model, ImageDisplay rootNode) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (rootNode == null) {
            throw new IllegalArgumentException("No root node.");
        }
        this.model = model;
        this.sorter = new ViewerSorter();
        this.numberImages = 0;
        TreeViewImageSet root = this.createTree(rootNode);
        Set nodes = rootNode.getChildrenDisplay();
        this.buildTreeNode(root, this.sorter.sort(nodes));
        this.createToolBar();
        this.createMenuBar();
        model.setPreferredSize(this.menuBar.getPreferredSize());
    }

    JTree getTree() {
        return this.tree;
    }

    JPanel getMenuBar() {
        return this.menuBar;
    }

    void selectNodes(TreeViewNode oldNode, TreeViewNode newNode) {
        TreeCellRenderer renderer = (TreeCellRenderer)this.tree.getCellRenderer();
        if (oldNode != null) {
            renderer.getTreeCellRendererComponent(this.tree, oldNode, this.tree.isPathSelected(new TreePath(oldNode.getPath())), false, true, 0, false);
        }
        if (newNode != null) {
            TreePath path = new TreePath(newNode.getPath());
            this.tree.setSelectionPath(path);
            renderer.getTreeCellRendererComponent(this.tree, newNode, this.tree.isPathSelected(path), false, true, 0, false);
        }
    }

    void sortNodes(int index, ImageDisplay rootNode) {
        this.sorter.setByDate(0 == index);
        DefaultTreeModel dtm = (DefaultTreeModel)this.tree.getModel();
        TreeViewImageSet root = (TreeViewImageSet)dtm.getRoot();
        root.removeAllChildren();
        this.buildTreeNode(root, this.sorter.sort(rootNode.getChildrenDisplay()));
        dtm.reload();
    }

    TreeViewNode getRoot() {
        DefaultTreeModel dtm = (DefaultTreeModel)this.tree.getModel();
        return (TreeViewNode)dtm.getRoot();
    }
}

