/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.treeview;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewImageNode;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewNodeVisitor;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

public abstract class TreeViewNode
extends DefaultMutableTreeNode {
    private boolean partialName;
    private TreeViewNode parentNode;
    private Set childrenNode;

    private void checkAlgoType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Algorithm not supported.");
    }

    private String getPartialName(String originalName) {
        if (Pattern.compile("/").matcher(originalName).find()) {
            String[] l = originalName.split("/", 0);
            int n = l.length;
            if (n == 1) {
                return l[0];
            }
            return "..." + l[n - 2] + "/" + l[n - 1];
        }
        if (Pattern.compile("\\\\").matcher(originalName).find()) {
            String[] l = originalName.split("\\\\", 0);
            int n = l.length;
            if (n == 1) {
                return l[0];
            }
            return "..." + l[n - 2] + "\\" + l[n - 1];
        }
        return originalName;
    }

    protected TreeViewNode(Object userObject) {
        if (userObject == null) {
            throw new NullPointerException("No hierarchy object.");
        }
        this.setUserObject(userObject);
        this.childrenNode = new HashSet();
        this.partialName = true;
    }

    void setPartialName(boolean b) {
        this.partialName = b;
    }

    boolean isPartialName() {
        return this.partialName;
    }

    public TreeViewNode getParentNode() {
        return this.parentNode;
    }

    public Set getChildrenNode() {
        return Collections.unmodifiableSet(this.childrenNode);
    }

    public void addChildNode(TreeViewNode child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenNode.contains(child)) {
            return;
        }
        if (child.parentNode != null) {
            child.parentNode.removeChildNode(child);
        }
        child.parentNode = this;
        this.childrenNode.add(child);
    }

    public void removeChildNode(TreeViewNode child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenNode.contains(child)) {
            child.parentNode.childrenNode.remove(child);
            child.parentNode = null;
        }
    }

    public void removeAllChildrenNode() {
        Iterator i = this.childrenNode.iterator();
        HashSet toRemove = new HashSet(this.childrenNode.size());
        while (i.hasNext()) {
            toRemove.add(i.next());
        }
        i = toRemove.iterator();
        while (i.hasNext()) {
            this.removeChildNode((TreeViewNode)i.next());
        }
    }

    public void accept(TreeViewNodeVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("No visitor.");
        }
        this.accept(visitor, 2);
    }

    public void accept(TreeViewNodeVisitor visitor, int algoType) {
        if (visitor == null) {
            throw new NullPointerException("No visitor.");
        }
        this.checkAlgoType(algoType);
        Iterator i = this.childrenNode.iterator();
        switch (algoType) {
            case 0: {
                while (i.hasNext()) {
                    TreeViewNode child = (TreeViewNode)i.next();
                    child.accept(visitor, algoType);
                }
                if (!(this instanceof TreeViewImageNode)) break;
                this.doAccept(visitor);
                break;
            }
            case 1: {
                while (i.hasNext()) {
                    TreeViewNode child = (TreeViewNode)i.next();
                    if (!(child instanceof TreeViewImageSet)) continue;
                    child.accept(visitor, algoType);
                }
                if (!(this instanceof TreeViewImageSet)) break;
                this.doAccept(visitor);
                break;
            }
            case 2: {
                while (i.hasNext()) {
                    TreeViewNode child = (TreeViewNode)i.next();
                    child.accept(visitor, algoType);
                }
                this.doAccept(visitor);
            }
        }
    }

    private String nameToString(Object obj, boolean b) {
        if (obj instanceof ProjectData) {
            return ((ProjectData)obj).getName();
        }
        if (obj instanceof DatasetData) {
            return ((DatasetData)obj).getName();
        }
        if (obj instanceof ImageData) {
            if (b) {
                return this.getPartialName(((ImageData)obj).getName());
            }
            return ((ImageData)obj).getName();
        }
        if (obj instanceof CategoryGroupData) {
            return ((CategoryGroupData)obj).getName();
        }
        if (obj instanceof CategoryData) {
            return ((CategoryData)obj).getName();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof ImageSet) {
            return this.nameToString(((ImageSet)obj).getHierarchyObject(), b);
        }
        if (obj instanceof ImageNode) {
            return this.nameToString(((ImageNode)obj).getHierarchyObject(), b);
        }
        return "";
    }

    public String getNodeName() {
        return this.nameToString(this.getUserObject(), false);
    }

    public final boolean equals(Object x) {
        return this == x;
    }

    public String toString() {
        return this.nameToString(this.getUserObject(), this.partialName);
    }

    protected abstract void doAccept(TreeViewNodeVisitor var1);

    public abstract boolean containsImages();
}

