/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.treeview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewImageSet;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewNode;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewNodeVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewUI;

public class TreeView
extends JPanel {
    public static final String CLOSE_PROPERTY = "close";
    public static final String TREE_SELECTED_DISPLAY_PROPERTY = "treeSelectedDisplay";
    public static final String TREE_POPUP_POINT_PROPERTY = "treePopupPoint";
    public static final String REMOVE_ROLL_OVER_PROPERTY = "removeRollOver";
    private boolean display;
    private Point popupPoint;
    private TreeViewUI uiDelegate;
    private TreeViewNode selectedNode;

    private void checkAlgo(int algo) {
        switch (algo) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Algo not supported.");
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.uiDelegate.getMenuBar(), "North");
        this.add((Component)new JScrollPane(this.uiDelegate.getTree()), "Center");
    }

    public TreeView(ImageDisplay rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException("No root");
        }
        this.uiDelegate = new TreeViewUI(this, rootNode);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                TreeView.this.removeRollOver();
            }
        });
        this.buildGUI();
    }

    void close() {
        if (!this.display) {
            return;
        }
        this.firePropertyChange(CLOSE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    void collapseNode(TreeViewNode node) {
        if (node == null) {
            return;
        }
        TreeViewNode root = this.uiDelegate.getRoot();
        if (root.equals(node)) {
            return;
        }
        this.uiDelegate.getTree().collapsePath(new TreePath(node.getPath()));
    }

    void selectNode(TreeViewNode node) {
        this.uiDelegate.selectNodes(this.selectedNode, node);
        this.selectedNode = node;
    }

    void setSelectedDisplays(List nodes, TreeViewNode lastSelected) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        Iterator i = nodes.iterator();
        ImageDisplay[] uos = new ImageDisplay[nodes.size()];
        int index = 0;
        while (i.hasNext()) {
            uos[index] = (ImageDisplay)((TreeViewNode)i.next()).getUserObject();
        }
        this.selectedNode = lastSelected;
        ImageDisplay uo = (ImageDisplay)lastSelected.getUserObject();
        this.firePropertyChange(TREE_SELECTED_DISPLAY_PROPERTY, null, uos);
        this.firePropertyChange("scrollToNode", null, uo);
    }

    void setSelectedDisplay(TreeViewNode node) {
        if (node == null) {
            return;
        }
        this.selectedNode = node;
        ImageDisplay uo = (ImageDisplay)node.getUserObject();
        this.firePropertyChange(TREE_SELECTED_DISPLAY_PROPERTY, null, uo);
        this.firePropertyChange("scrollToNode", null, uo);
    }

    void setPopupPoint(Point p) {
        this.popupPoint = p;
        this.firePropertyChange(TREE_POPUP_POINT_PROPERTY, null, this.uiDelegate.getTree());
    }

    void removeRollOver() {
        this.firePropertyChange(REMOVE_ROLL_OVER_PROPERTY, Boolean.FALSE, Boolean.TRUE);
    }

    public boolean isDisplay() {
        return this.display;
    }

    public Point getPopupPoint() {
        return this.popupPoint;
    }

    public void setDisplay(boolean d) {
        this.display = d;
    }

    public void accept(TreeViewNodeVisitor visitor) {
        this.accept(visitor, 2);
    }

    public void accept(TreeViewNodeVisitor visitor, int algo) {
        this.checkAlgo(algo);
        DefaultTreeModel model = (DefaultTreeModel)this.uiDelegate.getTree().getModel();
        TreeViewImageSet root = (TreeViewImageSet)model.getRoot();
        root.accept(visitor, algo);
    }

    public void sortNodes(int index, ImageDisplay rootNode) {
        this.uiDelegate.sortNodes(index, rootNode);
    }
}

