/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.treeview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JToggleButton;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.PartialNameVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeView;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class PartialNameButton
extends JToggleButton
implements ActionListener {
    private static final String DESCRIPTION = "Show the full name of the image";
    private TreeView model;

    PartialNameButton(TreeView model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.setRolloverEnabled(true);
        this.addActionListener(this);
        IconManager im = IconManager.getInstance();
        this.setIcon(im.getIcon(IconManager.PARTIAL_NAME));
        this.setToolTipText(UIUtilities.formatToolTipText(DESCRIPTION));
    }

    public void actionPerformed(ActionEvent e) {
        PartialNameVisitor visitor = new PartialNameVisitor(!this.isSelected());
        this.model.accept(visitor, 0);
        this.model.repaint();
    }
}

