/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.treeview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.openmicroscopy.shoola.agents.hiviewer.IconManager;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.CollapseVisitor;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeView;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class CollapseButton
extends JButton
implements ActionListener {
    private static final String DESCRIPTION = "Collapse All";
    private TreeView model;

    CollapseButton(TreeView model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.setRolloverEnabled(true);
        this.addActionListener(this);
        IconManager im = IconManager.getInstance();
        this.setIcon(im.getIcon(37));
        this.setToolTipText(UIUtilities.formatToolTipText(DESCRIPTION));
    }

    public void actionPerformed(ActionEvent e) {
        CollapseVisitor visitor = new CollapseVisitor(this.model);
        this.model.accept(visitor, 1);
    }
}

