/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.hiviewer.tpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.BgPainter;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.HiBgPainter;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.Painter;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.SizeButton;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.TinyObserver;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.TinyPane;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.TinyPaneIcon;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.TinyPaneTitle;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.TitleBarLayout;
import org.openmicroscopy.shoola.agents.hiviewer.tpane.ViewModeButton;

class TitleBar
extends JComponent
implements PropertyChangeListener {
    private static final Painter NORMAL_PAINTER = new BgPainter();
    static final int H_SPACING = 2;
    static final int MIN_WIDTH = 48;
    private Painter bgPainter;
    private TinyPaneIcon icon;
    private SizeButton sizeButton;
    private ViewModeButton viewModeButton;
    private TinyPaneTitle title;
    private int fixedHeight;
    private TinyPane model;

    private void attachAll() {
        if (this.icon != null) {
            this.icon.attach();
        }
        if (this.sizeButton != null) {
            this.sizeButton.attach();
        }
        if (this.viewModeButton != null) {
            this.viewModeButton.attach();
        }
        if (this.title != null) {
            this.title.attach();
        }
    }

    private void detachAll() {
        TinyObserver[] comp = new TinyObserver[]{this.sizeButton, this.title};
        for (int i = 0; i < comp.length; ++i) {
            if (comp[i] == null) continue;
            comp[i].detach();
            this.remove((Component)((Object)comp[i]));
        }
    }

    private void update(Color highlightColor) {
        this.bgPainter = highlightColor == null ? NORMAL_PAINTER : new HiBgPainter(highlightColor);
        this.repaint();
    }

    private void update(int titleBarType, List decoration) {
        Iterator i = decoration.iterator();
        this.detachAll();
        this.removeAll();
        switch (titleBarType) {
            case 0: {
                this.fixedHeight = 0;
                break;
            }
            case 2: {
                this.fixedHeight = 4;
                break;
            }
            case 1: {
                this.fixedHeight = 12;
                while (i.hasNext()) {
                    this.add((JComponent)i.next());
                }
                break;
            }
            case 3: {
                this.fixedHeight = 18;
                this.icon = new TinyPaneIcon(this.model);
                this.add(this.icon);
                this.viewModeButton = new ViewModeButton(this.model);
                this.add(this.viewModeButton);
                this.sizeButton = new SizeButton(this.model);
                this.add(this.sizeButton);
                while (i.hasNext()) {
                    this.add((JComponent)i.next());
                }
                this.title = new TinyPaneTitle(this.model);
                this.add(this.title);
                break;
            }
            case 4: {
                this.fixedHeight = 18;
                this.icon = new TinyPaneIcon(this.model);
                this.add(this.icon);
                this.title = new TinyPaneTitle(this.model);
                this.add(this.title);
            }
        }
        this.attachAll();
    }

    TitleBar(TinyPane model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        model.addPropertyChangeListener(this);
        this.update(model.getHighlight());
        this.update(model.getTitleBarType(), model.getDecoration());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new TitleBarLayout());
    }

    int getFixedHeight() {
        return this.fixedHeight;
    }

    Rectangle getFrameIconBounds() {
        if (this.icon == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.icon.getBounds();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.bgPainter.paint(g2D, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        if ("highlight".equals(propName)) {
            this.update((Color)pce.getNewValue());
        } else if ("titleBarType".equals(propName)) {
            this.update((Integer)pce.getNewValue(), this.model.getDecoration());
        } else if ("decoration".equals(propName)) {
            this.update(this.model.getTitleBarType(), (List)pce.getNewValue());
        }
    }
}

